<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
require_once JPATH_COMPONENT . DS . 'helpers' . DS . 'digitalmarketx.php';

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewSearch extends JViewLegacy
{

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$model = $this->getModel();
		$option = JRequest::getVar('option');
		VersionLayer::script('jquery-1.7.1.min.js', 'components/'. $option . '/js/');
		VersionLayer::script('cart.js', 'components/'. $option . '/js/');
		$this->categories = $model->getCategories();
		$this->sortElements = $model->getSortElements();
		$this->filters = $model->getFilters();
		$this->documents = $model->getDocuments();
		$this->showResults = JFactory::getApplication()->input->getInt('results', 0);
		$this->pagination	= $this->get('Pagination');	
		DigitalMarketXHelper::renderStyle();
		parent::display($tpl);
	}

}
