<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewThankyou extends JViewLegacy
{

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$option = JRequest::getVar('option');
		VersionLayer::stylesheet('thankyou.css', 'components/'. $option . '/assets/');
		VersionLayer::script('ajax_source.js', 'components/'. $option . '/assets/js/', false);
		$accessCode = JRequest::getVar('digitalmarketxaccesscode');
		$this->cart_id = JRequest::getInt('id');
		$model = $this->getModel();
		if($model)
		{	
			if($this->cart_id)
			{
				if($model->isCartPaid($this->cart_id))
					$this->thank_you = $model->getShoppingCartThankyou();
				else
					$this->thank_you = JText::_("COM_DIGITALMARKETX_SHOPPINGCART_NOT_PAID");
				$this->accessCode = null;
			}
			else
			{
				list($download_id, $hash, $random) = explode(":", $accessCode);
				if($model->validateAccessCode($download_id, $hash, $random))
				{
					if($model->isDownloadPaid($download_id))
					{
						$thank_you = $model->getThankyouText($download_id);
					}
					else
					{
						$thank_you = JText::_("COM_DIGITALMARKETX_DOWNLOADLINK_NOT_PAID");
						$accessCode = "";
					}
				}
				else
				{
					$thank_you = "Unauthorized access";
					$accessCode = "";
				}
				$this->thank_you = $thank_you;
				$this->accessCode = $accessCode;
			}
			parent::display($tpl);
		}
	}

}
