<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

$root = JURI::root();
//JHTML::_('behavior.mootools'); 
JHTML::_('behavior.modal');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>
<script type="text/javascript">
function validateUploadForm()
{
	var title = document.getElementById('uploadtitle');
	if(title.value.trim() == '')
	{
		alert('<?php echo JText::_("COM_DIGITALMARKETX_TYPE_TITLE", true);?>');
		return false;
	}
	var uploadcategory = document.getElementById('uploadcategory');
	if(uploadcategory.value == '0')
	{
		alert('<?php echo JText::_("COM_DIGITALMARKETX_SELECT_CATEGORY", true);?>');
		return false;
	}
	var minprice = <?php echo $minprice = (float)$this->params->get('minprice', 0.01);?>;
	var maxprice = <?php echo $maxprice = (float)$this->params->get('maxprice', 1000000);?>;
	var uploadprice = document.getElementById('uploadprice');
	var regexp = /^\s*\d+(\.\d{0,2})?\s*$/;
	if(!regexp.test(uploadprice.value))
	{
		alert('<?php echo JText::_("COM_DIGITALMARKETX_SPECIFY_PRICE", true);?>');
		return false;
	}
	var price = parseFloat(uploadprice.value);
	if(price < minprice || price > maxprice)
	{
		alert('<?php echo addslashes(JText::sprintf("COM_DIGITALMARKET_PRICE_OUTOFRANGE", $minprice, $maxprice));?>');
		return false;
	}
	return true;
}
var defaultPrice = <?php echo (float)$this->params->get('defaultprice', 10.00);?>;
var defaultcurrency = <?php echo (float)$this->params->get('defaultcurrency', 'USD');?>;
var categories = new Array();
var cat;
<?php
	foreach($this->categories as $category)
	{
	?>
	cat = new Object;
	cat.id = <?php echo (int)$category->id;?>;
	cat.canChangePrice = <?php echo $category->canChangePrice ? 'true' : 'false';?>;
	cat.canChangeCurrency = <?php echo $category->canChangeCurrency ? 'true' : 'false';?>;
	cat.canEditState = <?php echo $category->canEditState ? 'true' : 'false';?>;
	cat.canAssignUsers = <?php echo $category->canAssignUser ? 'true' : 'false';?>;
	categories.push( cat );
	<?php
	}
?>
</script>
<form method="post" action="<?php echo JRoute::_("index.php?option=com_digitalmarketx&task=document.upload");?>" name="uploadForm" id="upload-form" enctype="multipart/form-data" onsubmit="return validateUploadForm();">
<div class="adminform">
	<fieldset>
		<legend><?php echo htmlspecialchars(JText::_('COM_DIGITALMARKETX_UPLOAD')); ?></legend>
		<ul class="adminformlist">
		<li><label for="uploadtitle" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_TITLE_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FORM_LBL_DOCUMENT_TITLE"));?><span class="required">*</span></label>
		<input type="text" name="title" id="uploadtitle" maxlength="255" size="50"/>
		</li>
		<li><label for="uploadcategory" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_CATEGORY_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FORM_LBL_DOCUMENT_CATEGORY"));?><span class="required">*</span></label>
		<select name="category" id="uploadcategory" onchange="categoryChanged();">
		<option value="0"><?php  echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SELECT_CATEGORY"));?></option>
		<?php
		foreach($this->categories as $category)
		{
		$title = "";
		for($i = 0; $i < $category->depth; $i++)
			$title .= "--";
		$title .= htmlspecialchars($category->title);
		$selected = ($category->enabled && $this->currentCat == $category->id) ? "selected" : "";
		?>
		<option value="<?php echo htmlspecialchars($category->id)?>" <?php echo $selected;?> <?php if(!$category->enabled) echo "disabled"; ?>><?php echo $title;?></option>
		<?php
		}
		?>
		</select>
		</li>
		<li><label for="uploadprice" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_PRICE_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_PRICE"));?><span class="required">*</span></label>
		<input type="text" name="price" id="uploadprice" maxlength="30" size="10" value="<?php echo htmlspecialchars(isset($this->doc) && $this->doc ? $this->doc->price : $this->params->get('defaultprice', 10));?>"/>
		</li>
		<li><label for="uploadcurrency" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_CURRENCY_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CURRENCY"));?><span class="required">*</span></label>
		<select name="currency" id="uploadcurrency">
		<?php
		$cur = $this->doc ? $this->doc->currency : $this->params->get('defaultcurrency', 'USD');
		foreach($this->currencies as $currency)
		{
		$selected = ($cur == $currency) ? "selected" : "";;
		$currency = htmlspecialchars($currency);
		?>
		<option value="<?php echo $currency;?>" <?php echo $selected;?>><?php echo $currency;?></option>
		<?php
		}
		?>
		</select>
		</li>
		<li>
		<label for="published" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_PUBLISHED_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_PUBLISHED"));?></label>
		<input type="checkbox" name="published" id="published" value="1"/>
		</li>
		<?php 
		//if($this->canAssignUser)
		{
		?>
		<li id="select_users_region" <?php if(!$this->canAssignUser){?> style="display: none;" <?php }?>>
		<div style="clear:both;"></div>
		<label class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_USERS_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DESTINATION_USERS"));?></label>
		<input type="hidden" name="destusers_userids" id="destusers_userids" value=""/>
		<div id="destusers_usernames" class="dmuserbox"></div>
		<div class="modalbutton">
		<a class="modal" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SELECT_USERS"));?>" href="index.php?option=com_digitalmarketx&view=users&tmpl=component&field=destusers" rel="{handler: 'iframe', size: {x: 500, y: 300}}"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_SELECT_USERS"));?></a>
		</div>
		</li>
		<?php
		}
		/*else
		{
		?>
		<input type="hidden" name="destusers_userids" value="no"/>
		<?php
		}*/
		?>
		<li>
		<label for="file" class="hasTip required" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_FILE_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FILE"));?><span class="required">*</span></label>
		<input type="file" name="file" id="file" size="40"/>
		</li>
		<li>
		<label for="thumbnail" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_THUMBNAIL_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_THUMBNAIL_PREVIEW"));?></label>
		<input type="file" name="thumbnail" id="thumbnail" size="40"/>
		</li>
		<li>
		<label for="demo_file" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_DEMO_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKET_DEMO"));?></label>
		<input type="file" name="demo_file" id="demo_file" size="40"/>
		<input type="hidden" name="demo_text" value=""/>
		</li>
		<li><label for="keywords" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_KEYWORDS_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FILE_KEYWORDS"));?></label>
		<input type="text" name="keywords" id="keywords" maxlength="255" size="50"/>
		</li>
		<li>
		<label for="description" class="hasTip" title="<?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DOCUMENT_DESCRIPTION_TOOLTIP"));?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_DESCRIPTION"));?></label>
		<?php
		if($this->canUseHtml)
		{
		?>
		<div style="float:left;">
		<?php
		$editor = JFactory::getEditor();
		echo $editor->display('description', '', '100%', '200', '20', '20', false);	
		?>
		</div>
		<?php
		}
		else
		{
		?>
		<textarea style="width:60%; height:250px;" name="description" id="description" maxlength="5000"></textarea>
		<?php
		}
		?>
		</li>
		</ul>
		<script type="text/javascript">categoryChanged();</script>
		<div style="clear: both;"></div>
		<?php
		if($this->currentCat)
			$detailsUrl = JRoute::_("index.php?option=com_digitalmarketx&view=category&id=" . (int)$this->currentCat);
		$version = new JVersion();
		if($version->RELEASE < "3.0")
		{
		?>
		<div class="uploadbuttons">
		<button type="submit" class="submitbutton" name="upload"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_UPLOAD"));?></button>
		<?php
		if($this->currentCat)
		{
		?>
		<a href="<?php echo $detailsUrl;?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_CANCEL"));?></a>
		<?php 
		}
		?>
		</div>
		<?php
		}
		else
		{
		?>
		<div id="form-login-submit" class="control-group">
		<div class="controls">
			<button type="submit" tabindex="0" name="upload" class="btn btn-primary"><?php echo JText::_('COM_DIGITALMARKETX_UPLOAD') ?></button>
			<?php
			if($this->currentCat)
			{
			?>
			<a class="btn" href="<?php echo $detailsUrl;?>" title="<?php echo JText::_('JCANCEL');?>"><?php echo JText::_('JCANCEL');?></a>
			<?php
			}
			?>
		</div>
		</div>
		<?php
		}
		?>
	</fieldset>
</div>
</form>