<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * Content categories view.
 *
 * @package		Joomla.Site
 * @subpackage	com_content
 * @since 1.5
 */
class DigitalMarketXViewUpload extends JViewLegacy
{

	/**
	 * Display the view
	 *
	 * @return	mixed	False on error, null otherwise.
	 */
	function display($tpl = null)
	{
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		$model = $this->getModel();
		$currentCat = JRequest::getInt('cat', 0);
		if($model->canUpload($currentCat))
		{
			$categories = $model->getCategories();
			$currencies = $model->getCurrencies();
			$canUseHtml = $model->canUseHTML();
			$canAssignUser = $model->canAssignUserInCategory($currentCat);
			$doc = null;
			$option = JRequest::getVar('option');
			$params = JComponentHelper::getParams('com_digitalmarketx');
			VersionLayer::stylesheet('common.css', 'components/'. $option . '/assets/');
			VersionLayer::stylesheet('upload.css', 'components/'. $option . '/assets/');
			VersionLayer::stylesheet('selusers.css', 'components/'. $option . '/assets/');
			VersionLayer::script('upload.js', 'components/'. $option . '/js/');
			VersionLayer::script('users.js', 'components/'. $option . '/js/');
			$this->assignRef('categories', $categories);
			$this->assignRef('currencies', $currencies);
			$this->assignRef('params', $params);
			$this->assignRef('document', $doc);
			$this->assignRef('canUseHtml', $canUseHtml);
			$this->assignRef('currentCat', $currentCat);
			$this->assignRef('canAssignUser', $canAssignUser);
			parent::display($tpl);
		}
		else if(JFactory::getUser()->id)
			echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_UPLOAD_NOT_ALLOWED"));
		else
			echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_LOGIN_TO_UPLOAD"));
			
	}

}
