<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

/**
 * Base controller class for Joresponder
 *
 * @package		Joomla.Administrator 
 * @since		1.6
 */
class JoresponderController extends JControllerLegacy
{
	/**
	 * Logic for Sending the email templates
	 */
        public function sendEmails()
        {
		// Initialise variables.
		$app	= JFactory::getApplication();
		$user	= JFactory::getUser();
		$db	= JFactory::getDbo();
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->format('Y-m-d H:i:s', true);
	
		$users = $this->_getActiveUsers();
	
		if(!empty($users))
		{
			foreach($users as $user)
			{
				$email_template_ids = $this->_hasAnyEmailToSend($user);
				
				if(!empty($email_template_ids))
				{
					foreach ($email_template_ids as $id) 
					{
						// check whether this email has been sent earlier
						$is_this_email_sent = $this->_isEmailSentAlready($user, $id);
			
						if(!$is_this_email_sent)
						{
							$email_info = $this->_getTemplateDetails($id);
			    
							// Get the Mailer
							$mailer = JFactory::getMailer();
			    
							// Build email message format.
							$mailer->setSender(array($app->getCfg('mailfrom'), $app->getCfg('fromname')));
							$mailer->setSubject(stripslashes($email_info->name));
							$mailer->setBody($email_info->text);
							$mailer->IsHTML(true);
			    
							$mailer->addRecipient($user->email);
			    
							// Send the Mail
							$rs	= $mailer->Send();
							
							// record this date time 
							$data = new stdClass();
							$data->user_id = $user->id;
							$data->email_id = $email_info->id;
							$data->track_date = $now;
							 
							try {
								$result = $db->insertObject('#__joresponder_tracks', $data);
							} catch (Exception $e) {
								exit();
							}
							echo $email_info->name. ' has been sent to '.$user->email.'<br>';
						}
					}
				}
			}
		}
	
		exit();                
        }
        /**
	 * Logic to find out email template to be sent for a specific user
	 */
        private function _hasAnyEmailToSend( $user )
        {
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->format('Y-m-d', true);
		
		$emails = $this->_getEmailTemplates();
		$email_template_ids = array();
		
		if(!empty($emails))
		{
			foreach ($emails as $email) 
			{
				if($email->send_on_date == $now)  // send on date is current date
				{
					$email_template_ids[] = $email->id;
				}
				elseif($email->send_after_days != null)
				{
					$date_obj1 = new DateTime($user->created_time);
					$date_obj2 = new DateTime($now);
					$date_diff = round(($date_obj2->format('U') - $date_obj1->format('U')) / (60*60*24));
					
					if($date_diff==$email->send_after_days)
					{
						$email_template_ids[] = $email->id;
					}
				}                    
			}
		}
		return $email_template_ids;
        }
        
        /**
	 * Logic to get all active users
	 */
        private function _getActiveUsers()
        {
		//initialise variables
		$db  		= JFactory::getDBO();
		    
		$query = 'SELECT au.*'
		    . ' FROM #__joresponder_users AS au'
		    . ' WHERE au.state =  1';
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		
		$users = $db->loadObjectList();
		
		return $users;
        }
        
        /**
	 * Logic for retrive the email templates list
	 */
        private function _getEmailTemplates()
        {
		$db  	=  JFactory::getDBO();
		    
		$query = 'SELECT *'
		    . ' FROM #__joresponder_messages'
		    . ' WHERE state = 1 ';
		
		$db->setQuery($query);
		if(!$db->query()){
		    JError::raiseError(500, $db->getErrorMsg());
		    return false;
		}
		
		$rows = $db->loadObjectList();
		
		return $rows;
        }
        /**
	 * Logic for retrive the details of a email template
	 */
        private function _getTemplateDetails($id = 0)
        {
		$db  = JFactory::getDBO();
		    
		$query = 'SELECT *'
		    . ' FROM #__joresponder_messages'
		    . ' WHERE id = '.(int) $id
		    ;
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		
		$row = $db->loadObject();
		return $row;
        }
        /**
	 * Logic to check whether this email has been sent earlier
	 */
        private function _isEmailSentAlready($user, $id)
        {
		//initialise variables
		$db  	=  JFactory::getDBO();
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->format('Y-m-d', true);
		    
		$query = 'SELECT id'
			. ' FROM #__joresponder_tracks'
			. ' WHERE user_id = '.$user->id
			. ' AND email_id = '.$id 
			. ' AND DATE(track_date) = '.$db->Quote($now);
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		
		$id = $db->loadResult();
		
		if($id > 0 || $id){
			return true;
		}
		return false;
        }
	
	public function subscribe()
	{
		//initialise variables
		$db  	=  JFactory::getDBO();
		$date 	= JFactory::getDate();
		$cparams = JComponentHelper::getParams('com_joresponder');
		$post 	=  JRequest::get('post');
		
		$email_sender = $cparams->get('email_sender', '');
		$redirect_url = $cparams->get('redirect_url', 'index.php');
		$optin = $cparams->get('optin', 0);
		$subscribe_notify = $cparams->get('subscribe_notify', 1);
		$unsubscribe_notify = $cparams->get('unsubscribe_notify', 1);
		
		if(!empty($post))
		{
			$code=substr(md5($post['email'].microtime()),0,8);
			
			// first check if this email is already registered
			$query = 'SELECT id'
				. ' FROM #__joresponder_users'
				. ' WHERE email = '.$db->Quote($post['email']);
			
			$db->setQuery($query);
			if(!$db->query()){
				JError::raiseError(500, $db->getErrorMsg());
				return false;
			}
			$uid = $db->loadResult();
			
			if(!$uid)
			{
				$user_data = new stdClass();
				$user_data->name = $post['user_name'];
				$user_data->email = $post['email'];
				$user_data->state = ($optin) ? 0 : 1;
				$user_data->created_by = 0;
				$user_data->created_time = $date->toSql();
				$user_data->code = $code;
				$user_data->ip = $_SERVER[REMOTE_ADDR];
				
				try { 
					$result = $db->insertObject('#__joresponder_users', $user_data);
				} catch (Exception $e) {
					// catch the error.
				}
				$uid = $db->insertid();
			}
			else {
				$user_data = new stdClass();
				$user_data->id = $uid;
				$user_data->code = $code;
				
				try { 
					$result = $db->updateObject('#__joresponder_users', $user_data, 'id');
				} catch (Exception $e) {
					// catch the error.
				}
			}
			
			if($optin)
			{
				// send confirmation email
				$url=JURI::base()."index.php?option=com_joresponder&task=confirm&code=$code&id=$uid";
				
				$subject="Please confirm your email";
				$message="Please click on the link below or copy and paste it in the browser address bar:<br><br>".
				'<a href="'.$url.'">'.$url.'</a>';		
				
				$this->_send_mail($email_sender,$post['email'],$subject,$message);
				
				$this->setRedirect($redirect_url, 'Please check your email. A confirmation link is sent to it.');
			}
			else {
				$this->_send_welcome_mail($uid);

				// notify admin?
				if($subscribe_notify==1) {
					$this->_subscribe_notify($uid);
				}
				
				// redirect user to
				$this->setRedirect($redirect_url, 'You have been subcribed!');
			}
		}
	}
	
	/* sends the first welcome mail to newly registered or imported user
	if such has been scheduled. Scheduling of those mails is done by setting "0" for "days" */
	/* sends the first welcome mail to newly registered or imported user
	if such has been scheduled. Scheduling of those mails is done by setting "0" for "days" */
	private function _get_welcome_mail()
	{
		$db  	=  JFactory::getDBO();
		
		// first check if this email is already registered
		$query = 'SELECT *'
			. ' FROM #__joresponder_messages'
			. ' WHERE send_after_days = 0';
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$welcome_mail = $db->loadObject();
		return $welcome_mail;
	}
	
	private function _send_welcome_mail($uid)
	{
		$db  	=  JFactory::getDBO();
		
		// select member
		$query = 'SELECT *'
			. ' FROM #__joresponder_users'
			. ' WHERE id = '.(int)$uid
			. ' AND state = 1'
			;
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$member = $db->loadObject();
		
		if(empty($member)) return false;
		
		$mail = $this->_get_welcome_mail();
		if(empty($mail)) return false;
		
		$this->_customize_welcome_email($mail,$member);
	}
	
	/* private function called to customize an email message and send it */
	private function _customize_welcome_email($mail,$member)
	{
		$cparams = JComponentHelper::getParams('com_joresponder');
		$email_sender = $cparams->get('email_sender', '');
		
		// send mail to member
		$subject=$mail->name;				
		$message=$mail->text;
		
		$subject=str_replace("{{name}}",$member->name,$subject);
		$subject=str_replace("{{email}}",$member->email,$subject);
		
		$message=str_replace("{{name}}",$member->name,$message);
		$message=str_replace("{{email}}",$member->email,$message);

		// add unsubscribe link
		$unsub_url = JURI::base()."index.php?option=com_joresponder&task=unsubscribe&email=".urlencode($member->email);
		$message.="<br><br>
		To unsubscribe from our list visit the url below:<br>
		<a href='$unsub_url'>$unsub_url</a>";
		$message=str_replace("\t","",$message);
		
		$this->_send_mail($email_sender,$member->email,$subject,$message);
		
		// record this date time
		$db  	=  JFactory::getDBO();
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->format('Y-m-d H:i:s', true);
		
		$data = new stdClass();
		$data->user_id = $member->id;
		$data->email_id = $mail->id;
		$data->track_date = $now;
		 
		try {
			$result = $db->insertObject('#__joresponder_tracks', $data);
		} catch (Exception $e) {
		}
	}
	
	// unsubscribe user
	public function unsubscribe()
	{
		$db  	=  JFactory::getDBO();
		$cparams = JComponentHelper::getParams('com_joresponder');
		$unsubscribe_notify = $cparams->get('unsubscribe_notify', 1);
		
		$email = JRequest::getVar('email', '');
		$email=urldecode($email);
		
		$query="DELETE FROM #__joresponder_users WHERE email=".$db->Quote($email);
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		
		//  notify admin?
		if($unsubscribe_notify==1) {
			$this->_unsubscribe_notify($email);
		}
		
		$this->setRedirect('index.php');
	}
	
	// confirm user registration
	public function confirm()
	{
		$db  	=  JFactory::getDBO();
		$cparams = JComponentHelper::getParams('com_joresponder');
		$redirect_url = $cparams->get('redirect_url', 'index.php');
		$subscribe_notify = $cparams->get('subscribe_notify', 1);
		
		$uid = JRequest::getVar('id', 0);
		$code = JRequest::getVar('code', '');
		
		$query = 'SELECT *'
			. ' FROM #__joresponder_users'
			. ' WHERE id = '.(int)$uid
			. ' AND code = '.$db->Quote($code)
			;
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$member = $db->loadObject();
		
		if(!empty($member))
		{
			$user_data = new stdClass();
			$user_data->id = $member->id;
			$user_data->code = substr(md5($code.time()),0,8);
			$user_data->state = 1;
			
			try { 
				$result = $db->updateObject('#__joresponder_users', $user_data, 'id');
			} catch (Exception $e) {
				// catch the error.
			}
			
			$this->_send_welcome_mail($member->id);

			// notify admin?
			if($subscribe_notify==1) {
				$this->_subscribe_notify($member->id);
			}
		}
		$this->setRedirect($redirect_url);
	}
	
	// send notice when someone subscribes
	private function _subscribe_notify($mid)
	{
		$db  	=  JFactory::getDBO();
		$cparams = JComponentHelper::getParams('com_joresponder');
		$email_sender = $cparams->get('email_sender', '');
		
		$query = 'SELECT *'
			. ' FROM #__joresponder_users'
			. ' WHERE id = '.(int)$mid
			;
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$member = $db->loadObject();
		
		$subject = "New user subscribed to the mailing list";
		$message = 'User details:'."<br><p>".'Name:'.' '.$member->name.
			'</p><p>'.'Email:'.' '.$member->email;
		
		$this->_send_mail("",$email_sender,$subject,$message);
	}
	
	// send notice when someone unsubscribes
	private function _unsubscribe_notify($email)
	{
		$cparams = JComponentHelper::getParams('com_joresponder');
		$email_sender = $cparams->get('email_sender', '');
		
		$subject = "An user unsubscribed from the mailing list";
		$message = 'User email: '.$email;
		
		$this->_send_mail("",$email_sender,$subject,$message);
	}
	
	/* wrapper for joomla mail function */
	private function _send_mail($from="",$to,$subject,$message)
	{
		$db  	=  JFactory::getDBO();
		$mail = JFactory::getMailer();
		$jconfig = new JConfig();
		$MailFrom = $jconfig->mailfrom;
		$FromName = $jconfig->fromname;
		
		if($from!="") {
			$mail->setSender($from);
		}
		else {
			$mail->setSender(array($MailFrom, $FromName));
		}
		
		$mail->setSubject($subject);
		$mail->setBody($message);
		$mail->IsHTML(true);
		$mail->addRecipient($to);
	
		$sent = $mail->Send();
	}
}
