<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die ('Restricted access');

/**
 * @param int $module_id
 * @return stdClass
 */
function mjProxyModuleQuery($module_id)
{
    $joomlaWrapper = MjJoomlaWrapper::getInstance();
    $db = $joomlaWrapper->getDbo();

    $query = new MjQueryBuilder($db);
    $result = $query
        ->select('module', 'title')
        ->from('#__modules')
        ->where($query->qn('id') . '=' . (int)$module_id)
        ->setQuery()
        ->loadObject();
    if (!is_object($result)) {
        return null;
    }

    $name = substr($result->module, 4);

    // @todo getModule may return wromg instance in the case of identical titles
    $moduleObj =& JModuleHelper::getModule($name, $result->title);
    if (!is_object($moduleObj) || $moduleObj->id === 0) {
        return null;
    }
    return $moduleObj;
}

/**
 * @param stdClass $module
 * @param array $attribs
 * @return string
 */
function mjProxyModuleRender($module, $attribs)
{
    $doc = JFactory::getDocument();
    /** @var JDocumentRendererModule $renderer */
    $renderer = $doc->loadRenderer('module');
    return $renderer->render($module, $attribs);
}
