(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.toMarkdown = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
/*
 * to-markdown - an HTML to Markdown converter
 *
 * Copyright 2011-15, Dom Christie
 * Licenced under the MIT licence
 *
 */

'use strict';

var toMarkdown;
var converters;
var mdConverters = require('./lib/md-converters');
var gfmConverters = require('./lib/gfm-converters');
var collapse = require('collapse-whitespace');

/*
 * Set up window and document for Node.js
 */

var _window = (typeof window !== 'undefined' ? window : this), _document;
if (typeof document === 'undefined') {
  _document = require('jsdom').jsdom();
}
else {
  _document = document;
}

/*
 * Utilities
 */

function trim(string) {
  return string.replace(/^[ \r\n\t]+|[ \r\n\t]+$/g, '');
}

var blocks = ['address', 'article', 'aside', 'audio', 'blockquote', 'body',
  'canvas', 'center', 'dd', 'dir', 'div', 'dl', 'dt', 'fieldset', 'figcaption',
  'figure', 'footer', 'form', 'frameset', 'h1', 'h2', 'h3', 'h4','h5', 'h6',
  'header', 'hgroup', 'hr', 'html', 'isindex', 'li', 'main', 'menu', 'nav',
  'noframes', 'noscript', 'ol', 'output', 'p', 'pre', 'section', 'table',
  'tbody', 'td', 'tfoot', 'th', 'thead', 'tr', 'ul'
];

function isBlock(node) {
  return blocks.indexOf(node.nodeName.toLowerCase()) !== -1;
}

var voids = [
  'area', 'base', 'br', 'col', 'command', 'embed', 'hr', 'img', 'input',
  'keygen', 'link', 'meta', 'param', 'source', 'track', 'wbr'
];

function isVoid(node) {
  return voids.indexOf(node.nodeName.toLowerCase()) !== -1;
}

/*
 * Parsing HTML strings
 */

function canParseHtml() {
  var Parser = _window.DOMParser, canParse = false;

  // Adapted from https://gist.github.com/1129031
  // Firefox/Opera/IE throw errors on unsupported types
  try {
    // WebKit returns null on unsupported types
    if (new Parser().parseFromString('', 'text/html')) {
      canParse = true;
    }
  } catch (e) {}
  return canParse;
}

function createHtmlParser() {
  var Parser = function () {};

  Parser.prototype.parseFromString = function (string) {
    var newDoc = _document.implementation.createHTMLDocument('');

    if (string.toLowerCase().indexOf('<!doctype') > -1) {
      newDoc.documentElement.innerHTML = string;
    }
    else {
      newDoc.body.innerHTML = string;
    }
    return newDoc;
  };
  return Parser;
}

var HtmlParser = canParseHtml() ? _window.DOMParser : createHtmlParser();

function htmlToDom(string) {
  var tree = new HtmlParser().parseFromString(string, 'text/html');
  collapse(tree, isBlock);
  return tree;
}

/*
 * Flattens DOM tree into single array
 */

function bfsOrder(node) {
  var inqueue = [node],
      outqueue = [],
      elem, children, i;

  while (inqueue.length > 0) {
    elem = inqueue.shift();
    outqueue.push(elem);
    children = elem.childNodes;
    for (i = 0 ; i < children.length; i++) {
      if (children[i].nodeType === 1) { inqueue.push(children[i]); }
    }
  }
  outqueue.shift();
  return outqueue;
}

/*
 * Contructs a Markdown string of replacement text for a given node
 */

function getContent(node) {
  var text = '';

  for (var i = 0; i < node.childNodes.length; i++) {
    if (node.childNodes[i].nodeType === 1) {
      text += node.childNodes[i]._replacement;
    }
    else if (node.childNodes[i].nodeType === 3) {
      text += node.childNodes[i].data;
    }
    else { continue; }
  }
  return text;
}

/*
 * Returns the HTML string of an element with its contents converted
 */

function outer(node, content) {
  content = content || getContent(node);
  return node.cloneNode(false).outerHTML.replace('><', '>'+ content +'<');
}

function canConvert(node, filter) {
  if (typeof filter === 'string') {
    return filter === node.nodeName.toLowerCase();
  }
  if (Array.isArray(filter)) {
    return filter.indexOf(node.nodeName.toLowerCase()) !== -1;
  }
  else if (typeof filter === 'function') {
    return filter.call(toMarkdown, node);
  }
  else {
    throw new TypeError('`filter` needs to be a string, array, or function');
  }
}

function isFlankedByWhitespace(side, node) {
  var sibling, regExp, isFlanked;

  if (side === 'left') {
    sibling = node.previousSibling;
    regExp = / $/;
  }
  else {
    sibling = node.nextSibling;
    regExp = /^ /;
  }

  if (sibling) {
    if (sibling.nodeType === 3) {
      isFlanked = regExp.test(sibling.nodeValue);
    }
    else if(sibling.nodeType === 1 && !isBlock(sibling)) {
      isFlanked = regExp.test(sibling.textContent);
    }
  }
  return isFlanked;
}

function flankingWhitespace(node) {
  var leading = '', trailing = '';

  if (!isBlock(node)) {
    var hasLeading = /^[ \r\n\t]/.test(node.innerHTML),
        hasTrailing = /[ \r\n\t]$/.test(node.innerHTML);

    node.innerHTML = trim(node.innerHTML);

    if (hasLeading && !isFlankedByWhitespace('left', node)) {
      leading = ' ';
    }
    if (hasTrailing && !isFlankedByWhitespace('right', node)) {
      trailing = ' ';
    }
  }

  return { leading: leading, trailing: trailing };
}

/*
 * Finds a Markdown replacement if one exists, and sets it on `_replacement`
 */

function process(node) {
  var replacement;

  // Remove blank, non-anchor nodes
  if (!isVoid(node) && !/A/.test(node.nodeName) && /^\s*$/i.test(getContent(node))) {
    replacement = '';
  }
  else {
    for (var i = 0; i < converters.length; i++) {
      var converter = converters[i];

      if (canConvert(node, converter.filter)) {
        if (typeof converter.replacement !== 'function') {
          throw new TypeError(
            '`replacement` needs to be a function that returns a string'
          );
        }

        var whitespace = flankingWhitespace(node);

        replacement = converter.replacement.call(toMarkdown, getContent(node), node);
        replacement = whitespace.leading + replacement + whitespace.trailing;
        break;
      }
    }
  }

  node._replacement = (typeof replacement === 'string') ? replacement : outer(node);
}

toMarkdown = function (input, options) {
  options = options || {};

  if (typeof input !== 'string') {
    throw new TypeError(input + ' is not a string');
  }

  // Escape potential ol triggers
  input = input.replace(/(\d+)\. /g, '$1\\. ');

  var clone = htmlToDom(input).body,
      nodes = bfsOrder(clone),
      output;

  converters = mdConverters.slice(0);
  if (options.gfm) {
    converters = gfmConverters.concat(converters);
  }

  // Process through nodes in reverse (so deepest child elements are first).
  for (var i = nodes.length - 1; i >= 0; i--) {
    process(nodes[i]);
  }
  output = getContent(clone);

  return output.replace(/^[\t\r\n]+|[\t\r\n\s]+$/g, '')
               .replace(/\n\s+\n/g, '\n\n')
               .replace(/\n{3,}/g, '\n\n');
};

toMarkdown.isBlock = isBlock;
toMarkdown.trim = trim;
toMarkdown.outer = outer;

module.exports = toMarkdown;

},{"./lib/gfm-converters":2,"./lib/md-converters":3,"collapse-whitespace":5,"jsdom":6}],2:[function(require,module,exports){
'use strict';

function cell(content, node) {
  var index = Array.prototype.indexOf.call(node.parentNode.childNodes, node);
  var prefix = ' ';
  if (index === 0) { prefix = '| '; }
  return prefix + content + ' |';
}

var highlightRegEx = /highlight highlight-(\S+)/;

module.exports = [
  {
    filter: 'br',
    replacement: function () {
      return '\n';
    }
  },
  {
    filter: ['del', 's', 'strike'],
    replacement: function (content) {
      return '~~' + content + '~~';
    }
  },

  {
    filter: function (node) {
      return node.type === 'checkbox' && node.parentNode.nodeName === 'LI';
    },
    replacement: function (content, node) {
      return (node.checked ? '[x]' : '[ ]') + ' ';
    }
  },

  {
    filter: ['th', 'td'],
    replacement: function (content, node) {
      return cell(content, node);
    }
  },

  {
    filter: 'tr',
    replacement: function (content, node) {
      var borderCells = '';
      var alignMap = { left: ':--', right: '--:', center: ':-:' };

      if (node.parentNode.nodeName === 'THEAD') {
        for (var i = 0; i < node.childNodes.length; i++) {
          var align = node.childNodes[i].attributes.align;
          var border = '---';

          if (align) { border = alignMap[align.value] || border; }

          borderCells += cell(border, node.childNodes[i]);
        }
      }
      return '\n' + content + (borderCells ? '\n' + borderCells : '');
    }
  },

  {
    filter: 'table',
    replacement: function (content) {
      return '\n\n' + content + '\n\n';
    }
  },

  {
    filter: ['thead', 'tbody', 'tfoot'],
    replacement: function (content) {
      return content;
    }
  },

  // Fenced code blocks
  {
    filter: function (node) {
      return node.nodeName === 'PRE' &&
             node.firstChild &&
             node.firstChild.nodeName === 'CODE';
    },
    replacement: function(content, node) {
      return '\n\n```\n' + node.firstChild.textContent + '\n```\n\n';
    }
  },

  // Syntax-highlighted code blocks
  {
    filter: function (node) {
      return node.nodeName === 'PRE' &&
             node.parentNode.nodeName === 'DIV' &&
             highlightRegEx.test(node.parentNode.className);
    },
    replacement: function (content, node) {
      var language = node.parentNode.className.match(highlightRegEx)[1];
      return '\n\n```' + language + '\n' + node.textContent + '\n```\n\n';
    }
  },

  {
    filter: function (node) {
      return node.nodeName === 'DIV' &&
             highlightRegEx.test(node.className);
    },
    replacement: function (content) {
      return '\n\n' + content + '\n\n';
    }
  }
];

},{}],3:[function(require,module,exports){
'use strict';

module.exports = [
  {
    filter: 'p',
    replacement: function (content) {
      return '\n\n' + content + '\n\n';
    }
  },

  {
    filter: 'br',
    replacement: function () {
      return '  \n';
    }
  },

  {
    filter: ['h1', 'h2', 'h3', 'h4','h5', 'h6'],
    replacement: function(content, node) {
      var hLevel = node.nodeName.charAt(1);
      var hPrefix = '';
      for(var i = 0; i < hLevel; i++) {
        hPrefix += '#';
      }
      return '\n\n' + hPrefix + ' ' + content + '\n\n';
    }
  },

  {
    filter: 'hr',
    replacement: function () {
      return '\n\n* * *\n\n';
    }
  },

  {
    filter: ['em', 'i'],
    replacement: function (content) {
      return '_' + content + '_';
    }
  },

  {
    filter: ['strong', 'b'],
    replacement: function (content) {
      return '**' + content + '**';
    }
  },

  // Inline code
  {
    filter: function (node) {
      var hasSiblings = node.previousSibling || node.nextSibling;
      var isCodeBlock = node.parentNode.nodeName === 'PRE' && !hasSiblings;

      return node.nodeName === 'CODE' && !isCodeBlock;
    },
    replacement: function(content) {
      return '`' + content + '`';
    }
  },

  {
    filter: function (node) {
      return node.nodeName === 'A' && node.getAttribute('href');
    },
    replacement: function(content, node) {
      var titlePart = node.title ? ' "'+ node.title +'"' : '';
      return '[' + content + '](' + node.getAttribute('href') + titlePart + ')';
    }
  },

  {
    filter: 'img',
    replacement: function(content, node) {
      var alt = node.alt || '';
      var src = node.getAttribute('src') || '';
      var title = node.title || '';
      var titlePart = title ? ' "'+ title +'"' : '';
      return src ? '![' + alt + ']' + '(' + src + titlePart + ')' : '';
    }
  },

  // Code blocks
  {
    filter: function (node) {
      return node.nodeName === 'PRE' && node.firstChild.nodeName === 'CODE';
    },
    replacement: function(content, node) {
      return '\n\n    ' + node.firstChild.textContent.replace(/\n/g, '\n    ') + '\n\n';
    }
  },

  {
    filter: 'blockquote',
    replacement: function (content) {
      content = this.trim(content);
      content = content.replace(/\n{3,}/g, '\n\n');
      content = content.replace(/^/gm, '> ');
      return '\n\n' + content + '\n\n';
    }
  },

  {
    filter: 'li',
    replacement: function (content, node) {
      content = content.replace(/^\s+/, '').replace(/\n/gm, '\n    ');
      var prefix = '*   ';
      var parent = node.parentNode;
      var index = Array.prototype.indexOf.call(parent.children, node) + 1;

      prefix = /ol/i.test(parent.nodeName) ? index + '.  ' : '*   ';
      return prefix + content;
    }
  },

  {
    filter: ['ul', 'ol'],
    replacement: function (content, node) {
      var strings = [];
      for (var i = 0; i < node.childNodes.length; i++) {
        strings.push(node.childNodes[i]._replacement);
      }

      if (/li/i.test(node.parentNode.nodeName)) {
        return '\n' + strings.join('\n');
      }
      return '\n\n' + strings.join('\n') + '\n\n';
    }
  },

  {
    filter: function (node) {
      return this.isBlock(node);
    },
    replacement: function (content, node) {
      return '\n\n' + this.outer(node, content) + '\n\n';
    }
  }
];
},{}],4:[function(require,module,exports){
/**
 * This file automatically generated from `build.js`.
 * Do not manually edit.
 */

module.exports = [
  "address",
  "article",
  "aside",
  "audio",
  "blockquote",
  "canvas",
  "dd",
  "div",
  "dl",
  "fieldset",
  "figcaption",
  "figure",
  "footer",
  "form",
  "h1",
  "h2",
  "h3",
  "h4",
  "h5",
  "h6",
  "header",
  "hgroup",
  "hr",
  "noscript",
  "ol",
  "output",
  "p",
  "pre",
  "section",
  "table",
  "tfoot",
  "ul",
  "video"
];

},{}],5:[function(require,module,exports){
'use strict';

var blocks = require('block-elements').map(function (name) {
  return name.toUpperCase()
})

function defaultBlockTest (node) {
  return isElem(node) && blocks.indexOf(node.nodeName) >= 0
}

function isText (node) {
  return node && node.nodeType === 3
}

function isElem (node) {
  return node && node.nodeType === 1
}

/**
 * whitespace(elem [, isBlock]) removes extraneous whitespace from an
 * the given element. The function isBlock may optionally be passed in
 * to determine whether or not an element is a block element; if none
 * is provided, defaults to using the list of block elements provided
 * by the `block-elements` module.
 *
 * @param {Element} root
 * @param {Function} isBlock
 */
function whitespace (root, isBlock) {
  var startSpace = /^ /,
      endSpace = / $/,
      nextNode,
      prevNode,
      prevText,
      node,
      text

  if (typeof isBlock !== 'function')
    isBlock = defaultBlockTest

  function next (node) {
    while (node && node !== root) {
      if (node.nextSibling)
        return node.nextSibling

      node = node.parentNode
      if (prevText && isBlock(node)) {
        prevText.data = prevText.data.replace(/[ \r\n\t]$/, '')
        prevText = null
      }
    }

    return null
  }

  function first (node) {
    return node.firstChild ? node.firstChild : next(node)
  }

  function remove (node) {
    var nextNode = next(node)

    node.parentNode.removeChild(node)
    return nextNode
  }

  if (root.nodeName === 'PRE') return

  // Join adjacent text nodes and whatnot.
  root.normalize()

  node = first(root)
  while (node) {
    prevNode = node.previousSibling
    nextNode = node.nextSibling

    if (isText(node)) {
      text = node.data.replace(/[ \r\n\t]+/g, ' ')

      if (!prevText || prevNode && isBlock(prevNode))
        text = text.replace(startSpace, '')
      if (nextNode && isBlock(nextNode))
        text = text.replace(endSpace, '')

      if (prevText && endSpace.test(prevText.data) &&
          startSpace.test(text))
        text = text.substr(1)

      if (text) {
        node.data = text
        prevText = node
        node = next(node)
      } else {
        node = remove(node)
      }
    } else if (isElem(node)) {
      if (node.nodeName === 'PRE') {
        node = next(node)
        continue
      }

      if (prevText && isBlock(node)) {
        prevText.data = prevText.data.replace(endSpace, '')
        prevText = null
      }

      node = first(node)
    } else {
      node = remove(node)
    }
  }

  // Trim trailing space from last text node
  if (prevText)
    prevText.data = prevText.data.replace(endSpace, '')
}

module.exports = whitespace

},{"block-elements":4}],6:[function(require,module,exports){

},{}]},{},[1])(1)
});