<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');
jimport('joomla.environment.uri');

class plgSystemMobileJoomlaOpt extends JPlugin
{
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
    }

    public function onAfterRender()
    {
        if (!defined('_MJ')) {
            return;
        }

        // for safety reason don't optimize POST requests (may be a partial markup)
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            return;
        }

        /** @var JApplicationSite $app */
        $app = JFactory::getApplication();

        $mj_list = $app->triggerEvent('onGetMobileJoomla');
        /** @var MobileJoomla $mj */
        $mj = array_pop($mj_list);

        $text = JResponse::getBody();

        $app->triggerEvent('onMobilePagePrepare', array(&$text));

        if ($mj->getParam('ress_optimize')) {
//        $text = $mj->generator->processPage($text);
            require_once JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/ress/ressio.php';
//            if ($is_joomla15) {
//                /** @var array $classes */
//                $classes = include JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/ress/classmap.php';
//                foreach ($classes as $classname => $filepath) {
//                    JLoader::register($classname, $filepath);
//                }
//            }

            $options = array(
                'autostart' => false,
                'webrootpath' => JPATH_ROOT,
                'webrooturi' => JUri::root(true),
                'staticdir' => '/media/mj',
                'fileloader' => ($mj->getParam('distribmode') === 'php') ? 'php' : 'file',
                'fileloaderphppath' => JPATH_ROOT . '/media/mj/f.php',
                'cachedir' => JPATH_CACHE . '/mj',
                'html' => array(
                    'mergespace' => (bool)$mj->getParam('html_mergespace'),
                    'removecomments' => (bool)$mj->getParam('html_removecomments'),
                    'urlminify' => (bool)$mj->getParam('html_minifyurl'),
                    'gzlevel' => 0,
                    'sortattr' => (bool)$mj->getParam('html_sortattr'),
                    'removedefattr' => (bool)$mj->getParam('html_removedefattr'),
                    'removeiecond' => (bool)$mj->getParam('html_removeiecond')
                ),
                'css' => array(
                    'merge' => (bool)$mj->getParam('css_merge'),
                    'mergeinline' => (bool)$mj->getParam('css_mergeinline'),
                    'loadurl' => (bool)$mj->getParam('css_loadurl'),
                    'inlinelimit' => (int)$mj->getParam('css_inlinelimit'),
                    'minifyattribute' => (bool)$mj->getParam('css_minifyattribute'),
                    'excludemergeregex' => $this->listToRegex($mj->getParam('.css_excludelist', ''))
                ),
                'js' => array(
                    'merge' => (bool)$mj->getParam('js_merge'),
                    'mergeinline' => (bool)$mj->getParam('js_mergeinline'),
                    'loadurl' => (bool)$mj->getParam('js_loadurl'),
                    'autoasync' => (bool)$mj->getParam('js_autoasync'),
                    'wraptrycatch' => (bool)$mj->getParam('js_wraptrycatch'),
                    'inlinelimit' => (int)$mj->getParam('js_inlinelimit'),
                    'minifyattribute' => (bool)$mj->getParam('js_minifyattribute'),
                    'excludemergeregex' => $this->listToRegex($mj->getParam('.js_excludelist', ''))
                ),
                'img' => array(
                    'minify' => (bool)$mj->getParam('img_optimize', false),
                    'minifyrescaled' => false,
                    'jpegquality' => (int)$mj->getParam('jpegquality'),
                ),
                'amdd' => array(
                    'handler' => 'joomla',
                    'dbTableName' => '#__mj_amdd'
                ),
                'di' => array(
                    'jsMinify' => $mj->getParam('js_optimize') ? 'Ressio_JsMinify_JsMin' : 'Ressio_JsMinify_None',
                    'cssMinify' => $mj->getParam('css_optimize') ? 'Ressio_CssMinify_Ress' : 'Ressio_CssMinify_None',
//                'filesystem' => 'MJ_Ressio_FileSystem_Joomla',
                ),
                'plugins' => array(
                    'Ressio_Plugin_FilecacheCleaner' => null
                )
            );
            if ($mj->getParam('img')) {
                $options['plugins']['Ressio_Plugin_Rescale'] = array(
                    'setdimension' => true,
                    'bufferwidth' => (int)$mj->getParam('buffer_width'),
                    'scaletype' => $mj->getParam('img') ? 'fit' : '',
                    'hiresimages' => (bool)$mj->getParam('hiresimages', false),
                    'hiresjpegquality' => (int)$mj->getParam('hiresjpegquality', $mj->getParam('jpegquality')),
                    'keeporig' => false,
                    'wrapwideimg' => (bool)$mj->getParam('img_wrapwide', false),
                    'wideimgclass' => 'mjwideimg',
                );
            }
            $isAjaxRequest = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest');
            if (!$isAjaxRequest) {
                $img_lazyload = (bool)$mj->getParam('img_lazyload');
                $html_lazyiframe = (bool)$mj->getParam('html_lazyiframe');
                if ($img_lazyload || $html_lazyiframe) {
                    $template = $app->getTemplate();
                    $mjTemplates = array('mobile_basic', 'mobile_elegance', 'mobile_flat', 'mobile_square', 'mobile_ios9');
                    $options['plugins']['Ressio_Plugin_Lazyload'] = array(
                        'image' => $img_lazyload,
                        'iframe' => $html_lazyiframe,
                        'jqlight' => !in_array($template, $mjTemplates, true),
                        'addons' => array('jquerymobile')
                    );
                }
            }
            if ($mj->getParam('ress_streamoptimizer')) {
                $options['di']['htmlOptimizer'] = 'Ressio_HtmlOptimizer_Stream';
            }

            $app->triggerEvent('onMJRessioConfig', array(&$options));

            $ressio = new Ressio($options, true);
            require_once JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/classes/mjressiodevicedetector.php';
            $ressio->di->set('deviceDetector', new MJ_Ressio_DeviceDetector($mj->device));

            if ($mj->getParam('removetags')) {
                /** @var Ressio_Dispatcher $dispatcher */
                $dispatcher = $ressio->di->get('dispatcher');
                $dispatcher->addListener(
                    array(
//                        'HtmlIterateTagIFRAMEBefore',
                        'HtmlIterateTagOBJECTBefore',
                        'HtmlIterateTagEMBEDBefore',
                        'HtmlIterateTagAPPLETBefore'
                    ),
                    array($this, 'RessioRemoveTag')
                );
            }

            $app->triggerEvent('onMJRessioPrepare', array($ressio));

            $text = $ressio->run($text);
        }

        if (!empty($text)) {
            JResponse::setBody($text);
        }

        $app->triggerEvent('onMobileAfterPagePrepare');
    }

    /**
     * @param Ressio_Event $event
     * @param IRessio_HtmlOptimizer $optimizer
     * @param IRessio_HtmlNode $node
     */
    public function RessioRemoveTag($event, $optimizer, $node)
    {
        $optimizer->nodeDetach($node);
    }

    /**
     * @param string $str
     * @return string|null
     */
    private function listToRegex($str)
    {
        $list = explode("\n", trim($str));
        foreach ($list as $i => $line) {
            $line = trim($line);
            if ($line === '') {
                unset($list[$i]);
            } else {
                $list[$i] = preg_quote($line, '#');
            }
        }
        return count($list) === 0 ? null : '#(' . implode('|', $list) . ')#';
    }
}
