<?php
/**
 * abstract class for payment/shipment plugins
 *  
 * PinPaymentsForVirtueMart Payment Plugin
 *   
 * @author SoftPill.Eu
 * @link http://www.softpill.eu
 * @copyright Copyright (c) 2014 SoftPill.Eu. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.txt
 * This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version 1.0 March 2014
 */

//ini_set("display_errors",1);
//error_reporting(E_ALL);

defined('_JEXEC') or die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

if (!class_exists('vmPSPlugin')) {
    require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

class plgVmPaymentPinPaymentsForVirtueMart extends vmPSPlugin {

    // instance of class
    public static $_this = FALSE;

    function __construct(& $subject, $config) {
  		parent::__construct($subject, $config);
  		
  		$this->_loggable = TRUE;
  		$this->_debug = TRUE;
  		$this->tableFields = array_keys($this->getTableSQLFields());
  		$this->_tablepkey = 'id';
  		$this->_tableId = 'id';
  		$varsToPush = array(
      'account'             => array('', 'char'),
      'password'            => array('', 'char'),
      'test_mode'            => array('', 'char'),
      'show_logo'            => array('', 'char'),
      'instructions'            => array('', 'char'),
      'payment_logos'       => array('', 'char'),
      'countries'           => array('', 'char'),
      'cost_per_transaction'=> array('', 'int'),
      'cost_percent_total'  => array('', 'int'),
      'min_amount'          => array('', 'int'),
      'max_amount'          => array('', 'int'),
      'tax_id'              => array(0, 'int'),
      'status_pending'      => array('', 'char'),
      'status_success'      => array('', 'char'),
      'status_canceled'     => array('', 'char'));
  		$this->setConfigParameterable($this->_configTableFieldName, $varsToPush);
  	}

    public function getVmPluginCreateTableSQL() {
        return $this->createTableSQL('Payment Pin Payments Table');
    }

    function getTableSQLFields() {
        $SQLfields = array(
        'id' => 'int(11) UNSIGNED NOT NULL AUTO_INCREMENT',
      	'virtuemart_order_id' => 'int(1) UNSIGNED',
      	'order_number' => 'char(64)',
      	'virtuemart_paymentmethod_id' => 'mediumint(1) UNSIGNED',
      	'payment_name' => 'varchar(5000)',
      	'payment_order_total' => 'decimal(15,5) NOT NULL',
      	'payment_currency' => 'smallint(1)',
        'payment_order_total'     => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
      	'cost_per_transaction' => 'decimal(10,2)',
      	'cost_percent_total' => 'decimal(10,2)',
      	'tax_id' => 'smallint(1)',
        );
      	return $SQLfields;
    }
    function setParams($param_array,$comp_name)
    {
      if ( count($param_array) > 0 )
      {
        jimport('joomla.version');
        $jver = new JVersion();
        $jversion=$jver->getShortVersion();
        $joomla_ver=2;
        if(version_compare($jversion,'2.5','<'))
        {
          $joomla_ver=1;
        }
        if($joomla_ver==1)
        {
          $db = JFactory::getDbo();
          $params1=$this->getParams($comp_name);
          foreach ( $param_array as $name => $value )
          {
            $params1[ (string) $name ] = (string) $value;
          }
          $params="";
          foreach ( $params1 as $name => $value )
          {
            $params.=$name."=".$value."\n";
          }
          $db->setQuery('UPDATE #__plugins SET params = ' .
          $db->quote( $params ) .
          ' WHERE element = '.$db->quote($comp_name));
          $db->query();
        }
        else
        {
          $db = JFactory::getDbo();
          $db->setQuery('SELECT params FROM #__extensions WHERE element = '.$db->quote($comp_name));
          $params1 = json_decode( $db->loadResult(), true );
          foreach ( $param_array as $name => $value )
          {
            $params1[ (string) $name ] = (string) $value;
          }
          $params1String = json_encode( $params1 );
          $db->setQuery('UPDATE #__extensions SET params = ' .
          $db->quote( $params1String ) .
          ' WHERE element = '.$db->quote($comp_name));
          $db->query();
        }
      }
    }
    function getParams($comp_name)
    {
      jimport('joomla.version');
      $jver = new JVersion();
      $jversion=$jver->getShortVersion();
      $joomla_ver=2;
      if(version_compare($jversion,'2.5','<'))
      {
        $joomla_ver=1;
      }
      if($joomla_ver==1)
      {
        $params1=array();
        $db = JFactory::getDbo();
        $db->setQuery('SELECT params FROM #__plugins WHERE element = '.$db->quote($comp_name));
        $params=$db->loadResult();
        
        if($params!="")
        {
          $tarr=explode("\n",$params);
        }
        if(count($tarr)>0)
        {
          foreach($tarr as $p)
          {
            if($p!="")
            {
              $pos = strpos($p, "=");
              if ($pos === false) {}
              else
              {
                $key=substr($p,0,$pos);
                $val=substr($p,($pos+1),strlen($p));
                $params1[$key]=$val;
              }
            }
          }
        }
        return $params1;
      }
      else
      {
        $db = JFactory::getDbo();
        $db->setQuery('SELECT params FROM #__extensions WHERE element = '.$db->quote($comp_name));
        $params1 = json_decode( $db->loadResult(), true );
        return $params1;
      }
    }
  	function checkLicense($lic)
    {
      $checkurl='http://www.softpill.eu/check_complic.php?comp=pinpaymentsforvirtuemart&h='.str_ireplace("www.","",$_SERVER['HTTP_HOST']).'&lic='.$lic;
      if (!function_exists('curl_init'))
      {
        $output=@file_get_contents($checkurl);
        if($output==str_ireplace("www.","",$_SERVER['HTTP_HOST']))
        {
          $ok = 1;
        }
      }
      else
      {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $checkurl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $output = curl_exec($ch);
        curl_close($ch);
        if($output==str_ireplace("www.","",$_SERVER['HTTP_HOST']))
        {
          $ok = 1;
        }
      }
    
      
      $application = JFactory::getApplication();
      if(@$ok==1)
      {
        $chk=md5($lic.str_ireplace("www.","",$_SERVER['HTTP_HOST']));
        $this->setParams(array('dchk'=>$chk,'pinpaymentslic'=>$lic),'pinpaymentsforvirtuemart');
        $application->enqueueMessage('Thank You for Activating your Pin Payments - Payment Gateway', 'success');
        return 1;
      }
      else
      {
        $this->setParams(array('pinpaymentslic'=>'','dchk'=>''),'pinpaymentsforvirtuemart');
        $application->enqueueMessage('Provided License code is wrong', 'error');
        return 0;
      }
    }
    
    function plgVmConfirmedOrder($cart, $order) {
      
        $params1  = $this->getParams('pinpaymentsforvirtuemart');
        $dchk=$params1['dchk'];
        $lic=$params1['pinpaymentslic'];
        $chk=md5($lic.str_ireplace("www.","",$_SERVER['HTTP_HOST']));
        if($dchk!=$chk)
        {
          $application = JFactory::getApplication();
          if($lic=="")
          {
            $application->enqueueMessage('Please input your Pin Payments - Payment Gateway License Code', 'error');
            $this->setParams(array('pinpaymentslic'=>'','dchk'=>''),'pinpaymentsforvirtuemart');
            return;
          }
          else
          {
            $dchk=@$params1['dchk'];
            if($dchk=='')
            {
              if(!$this->checkLicense($lic))
              {
                return;
              }
            }
            else
            {
//               $chk=md5($lic.str_ireplace("www.","",$_SERVER['HTTP_HOST']));
//               if($chk!=$dchk)//check
//               {
//                 //$this->setParams(array('pinpaymentslic'=>'','dchk'=>''),'pinpaymentsforvirtuemart');
//                 $application->enqueueMessage('Provided License code is wrong', 'error');
//                 return;
//               }
            }
          }
        }
      
        if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id))) {
            return NULL; // Another method was selected, do nothing
        }
        if (!$this->selectedThisElement($method->payment_element)) {
            return FALSE;
        }
        $session = JFactory::getSession();
        $this->logInfo('plgVmConfirmedOrder order number: ' . $order['details']['BT']->order_number, 'message');

        if (!class_exists('VirtueMartModelOrders')) {
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        }
        if (!class_exists('VirtueMartModelCurrency')) {
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
        }

        $address = ((isset($order['details']['ST'])) ? $order['details']['ST'] : $order['details']['BT']);

        if (!class_exists('TableVendors')) {
            require(JPATH_VM_ADMINISTRATOR . DS . 'table' . DS . 'vendors.php');
        }

        $vendorModel = VmModel::getModel('Vendor');
        $vendorModel->setId(1);
        $vendor = $vendorModel->getVendor();
        $vendorModel->addImages($vendor, 1);
        $this->getPaymentCurrency($method);
        $currency_code_3 = shopFunctions::getCurrencyByID($method->payment_currency, 'currency_code_3');

        $paymentCurrency = CurrencyDisplay::getInstance($method->payment_currency);
        $totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order['details']['BT']->order_total, FALSE), 2);
        $cd = CurrencyDisplay::getInstance($cart->pricesCurrency);
        
        if ($totalInPaymentCurrency <= 0) {
            vmInfo('Payment Amount not valid for Pin Payments');
            return FALSE;
        }
        $merchant_account = $method->account;
        if (empty($merchant_account)) {
            vmInfo('Pin Payments Publishable API Key is not set. Please configure this parameter in your Pin Payments payment method.');
            return FALSE;
        }
        $merchant_password = $method->password;
        if (empty($merchant_password)) {
            vmInfo('Pin Payments Secret API Key is not set. Please configure this parameter in your Pin Payments payment method.');
            return FALSE;
        }
        $usrBT = $order['details']['BT'];
        $amount=number_format(round($order['details']['BT']->order_total,2),2)*100;
        
        $dbValues['order_number'] = $order['details']['BT']->order_number;
        $dbValues['payment_name'] = $this->renderPluginName($method, $order);
        $dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
        $dbValues['payment_currency'] = $method->payment_currency;
        $dbValues['payment_order_total'] = $totalInPaymentCurrency;
        $dbValues['cost_per_transaction'] = $method->cost_per_transaction;
    		$dbValues['cost_percent_total'] = $method->cost_percent_total;
    		$dbValues['tax_id'] = $method->tax_id;
        $this->storePSPluginInternalData($dbValues);
        
        $state=isset($usrBT->virtuemart_state_id) ? ShopFunctions::getStateByID($usrBT->virtuemart_state_id,'state_name') : '';
        $country=ShopFunctions::getCountryByID($usrBT->virtuemart_country_id,'country_2_code');
        $html=$this->_getPinHTML($method,$state,$country,$order,"",1);

        $cart->_confirmDone = FALSE;
        $cart->_dataValidated = FALSE;
        $cart->setCartIntoSession();
        JRequest::setVar('html', $html);
    }
    function _getMonthSelect($id)
    {
      $str='<select id="'.$id.'"><option value=""></option>';
      for($i=1;$i<=12;$i++)
      {
        $month=$i;
        if($month<10)
        {
          $month='0'.$month;
        }
        $sel="";
        if(date("m")==$month)
        {
          $sel=' selected="selected"';
        }
        $str.='<option value="'.$month.'"'.$sel.'>'.$month.'</option>';
      }
      $str.='</select>';
      return $str;
    }
    function _getYearSelect($id)
    {
      $str='<select id="'.$id.'"><option value="'.date("Y").'">'.date("Y").'</option>';
      $start=date("Y");
      $start++;
      $end=$start+7;
      for($i=$start;$i<=$end;$i++)
      {
        $str.='<option value="'.$i.'">'.$i.'</option>';
      }
      $str.='</select>';
      return $str;
    }
    function _getPinHTML($method,$state,$country,$order,$error,$type=0)
    {
      $doc =& JFactory::getDocument();
      $doc->addScript("https://cdn.pin.net.au/pin.v2.js");
      //$doc->addScript(juri::base()."plugins/vmpayment/pinpaymentsforvirtuemart/jPin.js");
      $doc->addStyleSheet( juri::base().'plugins/vmpayment/pinpaymentsforvirtuemart/pin.css' );
      $logo='';
      if($method->payment_logos!="")
      {
        foreach($method->payment_logos as $l)
        {
          $logo.='<img src="'.juri::base().'images/stories/virtuemart/payment/'.$l.'" />';
        }
      }
      $merchant_account = $method->account;
      $merchant_password = $method->password;
      $usrBT = $order['details']['BT'];
      $html='';
      $text_live='live';
      if($method->test_mode=='TEST')
      {
        $text_live='test';
        $html='
        <h3>Testing details</h3>
        <table class="pintesting">
          <tr>
            <td>Successful Response</td>
            <td>4200000000000000</td>
          </tr>
          <tr>
            <td>Card Declined</td>
            <td>4100000000000001</td>
          </tr>
          <tr>
            <td>Insufficient Funds</td>
            <td>4000000000000002</td>
          </tr>
          <tr>
            <td>Invalid CVV</td>
            <td>4900000000000003</td>
          </tr>
          <tr>
            <td>Invalid Card</td>
            <td>4800000000000004</td>
          </tr>
          <tr>
            <td>Processing Error</td>
            <td>4700000000000005</td>
          </tr>
          <tr>
            <td>Suspected Fraud</td>
            <td>4600000000000006</td>
          </tr>
          <tr>
            <td>Unknown</td>
            <td>4400000000000099</td>
          </tr>
          <tr>
            <td>Invalid Expiry</td>
            <td>To test invalid expiry dates, provide the API with an expiry date in the past.</td>
          </tr>
        </table>
        ';
      }
      //$pre_text='Please complete the form below to process your payment';
      //if($method->instructions!='')
      //{
        $pre_text=$method->instructions;
      //}
      $alert_notice=$method->alert_notice;
      $alert_notice=str_replace("'","\\'",$alert_notice);
      if($alert_notice=='')
      {
        $alert_notice='Please don\'t refresh the page, it may take up to 90 seconds to process the payment';
      }
      $charge_url="";
      if($type==1)
        $charge_url=JROUTE::_(JURI::root(). 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&on=' . $order['details']['BT']->order_number . '&pm=' . $order['details']['BT']->virtuemart_paymentmethod_id . '&Itemid=' . JRequest::getInt('Itemid'));
      $this->getPaymentCurrency($method);
      $currency_symbol = shopFunctions::getCurrencyByID($method->payment_currency, 'currency_symbol');
      $amount=number_format(round($order['details']['BT']->order_total,2),2);
      $month_select=$this->_getMonthSelect('cc-expiry-month');
      $year_select=$this->_getYearSelect('cc-expiry-year');
      $html .= '
        <form action="'.$charge_url.'" class="pin" method="post">
        <input type="hidden" id="address-line1" value="'.$usrBT->address_1.'" />
        <input type="hidden" id="address-line2" value="'.$usrBT->address_2.'" />
        <input type="hidden" id="address-city" value="'.$usrBT->city.'" />
        <input type="hidden" id="address-state" value="'.$state.'" />
        <input type="hidden" id="address-postcode" value="'.$usrBT->zip.'" />
        <input type="hidden" id="address-country" value="'.$country.'" />
        <h2>'.$pre_text.'</h2>
        <img id="progressimg" style="display:none;" src="'.juri::base().'plugins/vmpayment/pinpaymentsforvirtuemart/progress.gif" />
        <div class="pinerrors"><h3 id="ferror">'.$error.'</h3></div>
        <div class="pinerrors errors">
          <h3></h3>
          <ul></ul>
        </div>
        <table class="pinform">
          <tr>	
            <th>
              <label for="cc-number">Credit Card Number:
              </label>
            </th>	<td>		
              <input id="cc-number" type="text" size="20" maxlength="20" autocomplete="off" />	</td>
          </tr>
          <tr>	
            <th>
              <label for="cc-name">Name on Card:
              </label>
            </th>	<td>		
              <input id="cc-name" type="text" size="20" maxlength="20" autocomplete="off" />	</td>
          </tr>
          <tr>	
            <th>
              <label for="cc-expiry-month">Expiration:
              </label>
            </th>	<td>		
              '.$month_select.'
              <span style="font-weight:bold;"> / 
              </span>		
              '.$year_select.'	</td>
          </tr>
          <tr>	
            <th>
              <label for="cc-cvc">Security Code:
              </label>
            </th>	<td>		
              <input id="cc-cvc" type="text" maxlength="4" autocomplete="off" class="fewchars" />		
              <div id="cvc_container">			
                <div id="cvc_card">				
                  <div class="pinface">				
                    <div class="visa_back">
                    </div>				
                  </div>			 
                </div>		
              </div>	</td>
          </tr>
          <tr>
            <th>'.$logo.'</th>
            <td valign="top">
            <input type="submit" class="submit-button bright-green-button" value="Pay '.$amount." ".$currency_symbol.'" />
            </td>
          </tr>
        </table>
        <input type="hidden" name="action" value="charge" />
      </form>
      <script type="text/javascript">

      function showNoticeAlert()
      {
        alert("'.$alert_notice.'");
        return true;
      }


      jQuery(function() {

        var pinApi = new Pin.Api("'.$merchant_account.'", "'.$text_live.'");
      
        var form = jQuery("form.pin"),
            submitButton = form.find(":submit"),
            errorContainer = form.find(".errors"),
            errorList = errorContainer.find("ul"),
            errorHeading = errorContainer.find("h3");

        form.submit(function(e) {
          var cc=jQuery("#cc-number");
          var ccn=jQuery("#cc-name");
          var ccem=jQuery("#cc-expiry-month");
          var ccv=jQuery("#cc-cvc");
          
          if(cc.val()=="")
          {
            alert("Please input your Credit Card Number");
            cc.focus();
            return false;
          }
          if(ccn.val()=="")
          {
            alert("Please input your Name");
            ccn.focus();
            return false;
          }
          if(ccem.val()=="")
          {
            alert("Please select Credit Card Expiration Month");
            ccem.focus();
            return false;
          }
          if(ccv.val()=="")
          {
            alert("Please input your Credit Card Security Code");
            ccv.focus();
            return false;
          }
          
          jQuery("#ferror").html("");
          e.preventDefault();
          jQuery("#progressimg").show();

          errorList.empty();
          errorHeading.empty();
          errorContainer.hide();
      

          submitButton.attr({disabled: true});

          var card = {
            number:           jQuery("#cc-number").val(),
            name:             jQuery("#cc-name").val(),
            expiry_month:     jQuery("#cc-expiry-month").val(),
            expiry_year:      jQuery("#cc-expiry-year").val(),
            cvc:              jQuery("#cc-cvc").val(),
            address_line1:    jQuery("#address-line1").val(),
            address_line2:    jQuery("#address-line2").val(),
            address_city:     jQuery("#address-city").val(),
            address_state:    jQuery("#address-state").val(),
            address_postcode: jQuery("#address-postcode").val(),
            address_country:  jQuery("#address-country").val()
          };

          pinApi.createCardToken(card).then(handleSuccess, handleError).done();
        });
      
        function handleSuccess(card) {
          jQuery("#progressimg").hide();

          jQuery("<input>")
            .attr({type: "hidden", name: "card_token"})
            .val(card.token)
            .appendTo(form);

          showNoticeAlert();
          form.get(0).submit();
        }
      
        function handleError(response) {
          errorHeading.text(response.error_description);
          jQuery("#progressimg").hide();
          if (response.messages) {
            jQuery.each(response.messages, function(index, paramError) {
              jQuery("<li>")
                .text(paramError.param + ": " + paramError.message)
                .appendTo(errorList);
            });
          }
      
          errorContainer.show();

          submitButton.removeAttr("disabled");
        };
      });

      </script>
      ';
    return $html;
    }
    function _getPaymentResponseHtml($paymentTable,$payment_name,$method,$order)
    {
      $html='';
      if (!class_exists('VirtueMartModelCurrency')) {
          require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
      }
      
      $address = ((isset($order['details']['ST'])) ? $order['details']['ST'] : $order['details']['BT']);

      $vendorModel = VmModel::getModel('Vendor');
      $vendorModel->setId(1);
      $vendor = $vendorModel->getVendor();
      $vendorModel->addImages($vendor, 1);
      $this->getPaymentCurrency($method);
      $currency_code_3 = shopFunctions::getCurrencyByID($method->payment_currency, 'currency_code_3');

      $merchant_account = $method->account;
      if (empty($merchant_account)) {
          vmInfo('Pin Payments Publishable API Key is not set. Please configure this parameter in your Pin Payments payment method.');
          return FALSE;
      }
      $merchant_password = $method->password;
      if (empty($merchant_password)) {
          vmInfo('Pin Payments Secret API Key is not set. Please configure this parameter in your Pin Payments payment method.');
          return FALSE;
      }
      $usrBT = $order['details']['BT'];
      $amount=number_format(round($order['details']['BT']->order_total,2),2)*100;
      $text_live='';
      if($method->test_mode=='TEST')
      {
        $text_live='test-';
      }
      $error="";
      $action=isset($_POST['action'])?$_POST['action']:"";
      if($action=='charge')
      {
        $card_token=isset($_POST['card_token'])?$_POST['card_token']:"";
        if($card_token!="")
        {
          $api_key=$merchant_password;
          $url = "https://".$text_live."api.pin.net.au/1/charges";
          $post_fields_str='';
          $post_fields=array(
          'email'=>$usrBT->email,
          'description'=>'Your '.$_SERVER['HTTP_HOST'].' order.',
          'amount'=>$amount,
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'currency'=>$currency_code_3,
          'card_token'=>$card_token
          );
          foreach($post_fields as $key => $val)
          {
            $post_fields_str.=$key.'='.$val.'&';
          }
          
          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL, $url);
          curl_setopt($ch, CURLOPT_POST, 1);
          curl_setopt($ch, CURLOPT_USERPWD, "$api_key:");
          curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields_str);
          curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
          $result = curl_exec($ch);
          //echo $result;
          curl_close($ch);
          $msg=json_decode($result);
          if(isset($msg->error_description))
          {
            $error=$msg->error_description;
            $action='';
          }
          if(isset($msg->response) && isset($msg->response->success) && $msg->response->success)
          {
            $action='success';
          }
        }
        else
        {
          $action='';
          $error="Something whent wrong no card token, please contact administrator.";
        }
      }
      if($action=='success')
      {
        $html='';
        $modelOrder = VmModel::getModel('orders');
    		$order = array();
        $order_number = JRequest::getString('on', 0);
        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
            return NULL;
        }
    		$order['customer_notified'] = 1;
    		$order['order_status'] = $method->status_success;
    
    		$modelOrder->updateStatusForOneOrder($virtuemart_order_id, $order, FALSE);
        
        $db = JFactory::getDBO();
        $query="select order_pass from #__virtuemart_orders where order_number='".$order_number."'";
        $db->setQuery($query);
        $result=$db->loadObject();
        $cart = VirtueMartCart::getCart();
  		  $cart->emptyCart();
  			$app=JFactory::getApplication();
        $app->enqueueMessage('Thank you for your order.');
        $app->redirect(JURI::base().'index.php?option=com_virtuemart&view=orders&layout=details&order_number='.$order_number.'&order_pass='.$result->order_pass);
      }
      if($action=='')
      {
        $state=isset($usrBT->virtuemart_state_id) ? ShopFunctions::getStateByID($usrBT->virtuemart_state_id,'state_name') : '';
        $country=ShopFunctions::getCountryByID($usrBT->virtuemart_country_id,'country_2_code');
        $html=$this->_getPinHTML($method,$state,$country,$order,$error);
      }
  		return $html;
      
    }
    function plgVmOnPaymentResponseReceived(&$html) {
        if (!class_exists('VirtueMartCart')) {
            require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
        }
        if (!class_exists('shopFunctionsF')) {
            require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
        }
        if (!class_exists('VirtueMartModelOrders')) {
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        }

        $virtuemart_paymentmethod_id = JRequest::getInt('pm', 0);
        $order_number = JRequest::getString('on', 0);
        $vendorId = 0;
        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
            return NULL; // Another method was selected, do nothing
        }
        if (!$this->selectedThisElement($method->payment_element)) {
            return NULL;
        }

        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
            return NULL;
        }
        if (!($paymentTable = $this->getDataByOrderId($virtuemart_order_id))) {
            return '';
        }
        
        $payment_name = $this->renderPluginName($method);
        $modelOrder = VmModel::getModel('orders');
        $order=$modelOrder->getOrder($virtuemart_order_id);
        $html = $this->_getPaymentResponseHtml($paymentTable,$payment_name,$method,$order);
        return TRUE;
    }

    function plgVmOnUserPaymentCancel() {
        if (!class_exists('VirtueMartModelOrders')) {
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        }
        $order_number = JRequest::getString('on', '');
        $virtuemart_paymentmethod_id = JRequest::getInt('pm', '');
        if (empty($order_number) or empty($virtuemart_paymentmethod_id) or !$this->selectedThisByMethodId($virtuemart_paymentmethod_id)) {
            return NULL;
        }
        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
            return NULL;
        }
        if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
            return NULL; // Another method was selected, do nothing
        }
        $modelOrder = VmModel::getModel('orders');
        $order = array();
        vmInfo('Yo have canceled your Dummy order.');
        return TRUE;
    }

    function plgVmOnPaymentNotification() {
        if (!class_exists('VirtueMartModelOrders')) {
            require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        }

        $order_number = $_GET['order_id'];
        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($_GET['order_id']))) {
            return NULL;
        }
        $vendorId = 0;
        if (!($payments = $this->getDatasByOrderId($virtuemart_order_id))) {
            return NULL;
        }
        $method = $this->getVmPluginMethod($payments[0]->virtuemart_paymentmethod_id);

        $merchant_account = $method->account;
        $merchant_password = $method->password;
        exit;
    }

    /**
     * @param $virtuemart_order_id
     * @return mixed|string
     */
    function _getTablepkeyValue($virtuemart_order_id) {

        $db = JFactory::getDBO();
        $q = 'SELECT ' . $this->_tablepkey . ' FROM `' . $this->_tablename . '` '
                . 'WHERE `virtuemart_order_id` = ' . $virtuemart_order_id;
        $db->setQuery($q);

        if (!($pkey = $db->loadResult())) {
            JError::raiseWarning(500, $db->getErrorMsg());
            return '';
        }
        return $pkey;
    }

    function getCosts(VirtueMartCart $cart, $method, $cart_prices) {
        if (preg_match('/%$/', $method->cost_percent_total)) {
            $cost_percent_total = substr($method->cost_percent_total, 0, -1);
        } else {
            $cost_percent_total = $method->cost_percent_total;
        }
        return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
    }

    protected function checkConditions($cart, $method, $cart_prices) {
    $this->convert_condition_amount($method);

		$address = (($cart->ST == 0) ? $cart->BT : $cart->ST);

		$amount = $this->getCartAmount($cart_prices);
		$amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount
			OR
			($method->min_amount <= $amount AND ($method->max_amount == 0)));

		$countries = array();
		if (!empty($method->countries)) {
			if (!is_array($method->countries)) {
				$countries[0] = $method->countries;
			} else {
				$countries = $method->countries;
			}
		}
		// probably did not gave his BT:ST address
		if (!is_array($address)) {
			$address = array();
			$address['virtuemart_country_id'] = 0;
		}

		if (!isset($address['virtuemart_country_id'])) {
			$address['virtuemart_country_id'] = 0;
		}
		if (in_array($address['virtuemart_country_id'], $countries) || count($countries) == 0) {
			if ($amount_cond) {
				return TRUE;
			}
		}
    
		return FALSE;
    }


    /**
     * Create the table for this plugin if it does not yet exist.
     * This functions checks if the called plugin is active one.
     * When yes it is calling the standard method to create the tables
     */
    function plgVmOnStoreInstallPaymentPluginTable($jplugin_id) {
        return $this->onStoreInstallPluginTable($jplugin_id);
    }

    /**
     * This event is fired after the payment method has been selected. It can be used to store
     * additional payment info in the cart.
     */
    public function plgVmOnSelectCheckPayment(VirtueMartCart $cart, &$msg) {
        return $this->OnSelectCheck($cart);
    }

    /**
     * plgVmDisplayListFEPayment
     * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
     */
    public function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected = 0, &$htmlIn) {
        return $this->displayListFE($cart, $selected, $htmlIn);
    }

    /*
     * plgVmonSelectedCalculatePricePayment
     * Calculate the price (value, tax_id) of the selected method
     * It is called by the calculator
     * This function does NOT to be reimplemented. If not reimplemented, then the default values from this function are taken.
     */

    public function plgVmonSelectedCalculatePricePayment(VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {
        return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
    }

    /**
     * plgVmOnCheckAutomaticSelectedPayment
     * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
     * The plugin must check first if it is the correct type
     */
    function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {
        return $this->onCheckAutomaticSelected($cart, $cart_prices, $paymentCounter);
    }

    /**
     * This method is fired when showing the order details in the frontend.
     * It displays the method-specific data.
     */
    public function plgVmOnShowOrderFEPayment($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {
        $this->onShowOrderFE($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
    }

    function plgVmonShowOrderPrintPayment($order_number, $method_id) {
  		return $this->onShowOrderPrint($order_number, $method_id);
  	}
  	function plgVmDeclarePluginParamsPaymentVM3( &$data) {
  		return $this->declarePluginParams('payment', $data);
  	}
  	function plgVmSetOnTablePluginParamsPayment($name, $id, &$table) {
  		return $this->setOnTablePluginParams($name, $id, $table);
  	}

}

// No closing tag
