<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die('Restricted access');

/** @var JApplicationSite $app */
$app = JFactory::getApplication();
/** @var MobileJoomla $mj */
$mj_list = $app->triggerEvent('onGetMobileJoomla');
$mj = array_pop($mj_list);
if ($mj === null) {
    die('Enable System - Mobile Core plugin!');
}

include_once dirname(__FILE__) . '/includes/mjjqmframework.php';
include_once dirname(__FILE__) . '/includes/mj.renderer.php';
$this->mjJqmHelper = new MJJqmFramework($this);

//params
$theme_page = $this->params->get('theme_page');
$theme_header = $this->params->get('theme_header');

$doc = JFactory::getDocument();
$mjDevice = $mj->device; // used by common-headers.php

$base = $this->baseurl . '/templates/' . $this->template;

include dirname(__FILE__) . '/includes/process.php';
?>
<!doctype html>
<html>
<head>
<?php include dirname(__FILE__) . '/includes/common-headers.php'; ?>
<jdoc:include type="mjhead" />
</head>
<body>
<div data-role="page"<?php if ($theme_page) echo " data-theme=\"$theme_page\""; ?>>
<main class="content ui-content" data-role="main">
<jdoc:include type="message" />
<div class="jcomponent"<?php if (!$this->params->get('enhance')) echo ' data-enhance="false"'; ?>>
<?php if (!$mj->isHome() || $mj->getParam('componenthome')) echo '<jdoc:include type="component" />'; ?>
</div>
</main>
</div>
</body>
</html>