<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die;

class JFormFieldInfo extends JFormField
{
    protected $type = 'Info';

    protected function getLabel()
    {
        return '';
    }

    protected function getInput()
    {
        $title = (string)$this->element['title'];
        $docurl = (string)$this->element['docurl'];
        $extid = (int)$this->element['extid'];

        $html = array();

        $html[] = '<{jqmstart}/>';
        $html[] = '<p><h2>' . $title . ' 2.1.47</h2></p>';
		if($extid) {
			$html[] = '<p><b>Expiration</b>: <span class="mjactive"><span id="mjsubscription"></span> days left</span><span class="mjexpired">Expired</span> <a target="_blank" class="mjrenewurl ui-btn ui-mini" href="https://www.mobilejoomla.com/orders.html">Renew</a></p>';
			$css = '.mjactive,.mjexpired,.mjrenewurl{display:none}';
			$js = "
window.addEvent('domready',function(){
	function updateSubscription(expires){
		if(expires==''){//expired
			$$('.mjexpired').setStyle('display', 'inline-block');
			$$('.mjrenewurl').setStyle('display', 'inline-block');
		}else{//active
			var mjsubscription=$('mjsubscription');
			if(mjsubscription!=null){
				if(MooTools.version>='1.2')
					mjsubscription.set('html', expires);
				else
					mjsubscription.setHTML(expires);
			}
			$$('.mjactive').setStyle('display', 'inline-block');
			if(parseInt(expires)<=30)
				$$('.mjrenewurl').setStyle('display', 'inline-block');
		}
	}

	function checkSubscription(){
		if(typeof Request == 'function'){
			new Request.HTML( {
				url: '//www.mobilejoomla.com/getsubs.php?app=$extid&domain=' + document.domain,
				method: 'get',
				onSuccess : function(tree, elements, response){
					updateSubscription(response);
				}
			}).send();
		} else if(typeof Ajax == 'function'){
			new Ajax( '//www.mobilejoomla.com/getsubs.php?app=$extid&domain=' + document.domain, {
				method: 'get',
				onComplete: function(response){
					updateSubscription(response);
				}
			}).request();
		}
	}

	try{
		checkSubscription();
	}catch(e){}
});
";
			$doc = JFactory::getDocument();
			$doc->addStyleDeclaration($css);
			$doc->addScriptDeclaration($js);
		}
        $html[] = '<p>Template for <a target="_blank" href="https://www.mobilejoomla.com/">Mobile</a> extension</p>';
        $html[] = '<p><a target="_blank" href="' . $docurl . '">Documentation</a></p>';
        $html[] = '<p><a target="_blank" href="https://www.mobilejoomla.com/forum/18-premium-support.html">Premium support forum</a></p>';
        $html[] = '<{jqmend}/>';

        return implode($html);
    }
}
