<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die;

class JFormFieldJqmSlider extends JFormField
{
    protected $type = 'jqmSlider';

    protected function getLabel()
    {
        return '<{jqmstart}/><div class="ui-field-contain">' . parent::getLabel() . '<{jqmend}/>';
    }

    protected function getInput()
    {
        $html = array();
        $html[] = '<{jqmstart}/>';
        $html[] = '<input type="number" data-type="range" name="' . $this->name . '" id="' . $this->id . '"' .
            ' min="0" max="100" value="' . intval($this->value) .
            '" data-mini="true" data-highlight="true" />';
        $html[] = '</div><{jqmend}/>';

        return implode($html);
    }
}
