<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die;

class JFormFieldJqmSwitch extends JFormField
{
    protected $type = 'jqmSwitch';

    protected function getLabel()
    {
        return '<{jqmstart}/><div class="ui-field-contain">' . parent::getLabel() . '<{jqmend}/>';
    }

    protected function getInput()
    {
        $html = array();

        $options = array();
        $options[] = JHtml::_('select.option', '0',
            JText::alt('JNO', preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname))
        );
        $options[] = JHtml::_('select.option', '1',
            JText::alt('JYES', preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname))
        );

        $html[] = '<{jqmstart}/>';
        if ($this->fieldname === 'copyright' && !file_exists(JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/packages/version.dat')) {
            $html[] = '<a href="https://www.mobilejoomla.com/templates.html?utm_source=mjbackend&amp;utm_medium=TemplateManager-upgrade&amp;utm_campaign=Admin-upgrade" target="_blank">Available in Premium Templates</a>';
        } else {
            $html[] = JHtml::_('select.genericlist', $options, $this->name, ' data-role="flipswitch" data-mini="true" data-chosen="done" class="chzn-done"', 'value', 'text', $this->value, $this->id);
        }
        $html[] = '</div><{jqmend}/>';

        return implode($html);
    }
}
