<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die;

class JFormFieldJqmText extends JFormField
{
    protected $type = 'jqmText';

    protected function getLabel()
    {
        return '<{jqmstart}/><div class="ui-field-contain">' . parent::getLabel() . '<{jqmend}/>';
    }

    protected function getInput()
    {
        // Initialize some field attributes.
        $size = $this->element['size'] ? ' size="' . (int)$this->element['size'] . '"' : '';
        $maxLength = $this->element['maxlength'] ? ' maxlength="' . (int)$this->element['maxlength'] . '"' : '';

        $html = array();
        $html[] = '<{jqmstart}/>';
        $html[] = '<input type="text" name="' . $this->name . '" id="' . $this->id . '"'
            . ' value="' . htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') . '"'
            . ' placeholder="' . htmlspecialchars((string)$this->element['default'], ENT_COMPAT, 'UTF-8') . '"'
            . ' data-mini="true"' . $size . $maxLength . '/>';
        $html[] = '</div><{jqmend}/>';

        return implode($html);
    }
}
