<?php
/** @license  GNU General Public License version 2 or later; see LICENSE.txt */
// No direct access.
defined('_JEXEC') or die;

// Note. It is important to remove spaces between elements.

$dummy_urls = array('#', 'javascript:;');
?>
<ul data-role="listview" class="menu<?php echo $class_sfx;?>"<?php
	$tag = '';
	if ($params->get('tag_id') !== null) {
		$tag = $params->get('tag_id').'';
		echo ' id="'.$tag.'"';
	}
?>>
<?php
foreach ($list as $i => &$item) :
	$class = 'item-'.$item->id;
	$class_link = '';
	if ($item->id === $active_id) {
		$class .= ' current';
		$class_link .= ' ui-btn ui-btn-active';
	}

	$collapsed = '';
	if (in_array($item->id, $path)) {
		$class .= ' active';
		$collapsed = ' data-collapsed="false"';
	}
	elseif ($item->type === 'alias') {
		$aliasToId = $item->params->get('aliasoptions');
		if (count($path) > 0 && $aliasToId == $path[count($path)-1]) {
			$class .= ' active';
			$class_link .= ' ui-btn ui-btn-active';
		}
		elseif (in_array($aliasToId, $path)) {
			$class .= ' alias-parent-active';
		}
	}

	if ($item->parent) {
		$class .= ' parent';
	}

    // The next item is deeper.
	if ($item->deeper) {
		$class .= ' deeper';
		$class_header = $class . ' ui-btn';

		echo '<li data-role="collapsible" data-iconpos="right" data-inset="false"'.$collapsed.' class="'.trim($class_header).'">';
		echo '<h3>' . $item->title . '</h3>';
		echo '<ul class="ui-btn" data-role="listview">'; // don't match '<ul data-role="listview"'
	}

	if ($class !== '') {
		$class = ' class="' . trim($class) . '"';
	}
	$class_link = trim($class_link);

	// Render the menu item.
	switch ($item->type) :
		case 'separator':
		case 'heading':
			if (!$item->deeper) {
				echo '<li data-role="list-divider"' . $class . '>';
				require JModuleHelper::getLayoutPath('mod_menu', 'default_separator');
				echo '</li>';
			}
			break;

		case 'url':
		case 'component':
			if ($item->deeper && $item->type === 'url' && in_array($item->flink, $dummy_urls, true)) {
				 // skip duplication of separator-like URLs
			} else {
				echo '<li' . $class . '>';
				require JModuleHelper::getLayoutPath('mod_menu', 'default_' . $item->type);
				echo '</li>';
			}
			break;

		default:
			echo '<li'.$class.'>';
			require JModuleHelper::getLayoutPath('mod_menu', 'default_url');
			echo '</li>';
			break;
	endswitch;

	// The next item is shallower.
	if ($item->shallower) {
		echo str_repeat('</ul></li>', $item->level_diff);
	}
endforeach;
?></ul>
