<?php
/** @license  GNU General Public License version 2 or later; see LICENSE.txt */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.filter.output');

// Note. It is important to remove spaces between elements.
if ($item->anchor_css) {
    $class_link = trim($class_link . ' ' . $item->anchor_css);
}

$rel = '';
if (isset($item->anchor_rel)) {
    $rel .= $item->anchor_rel;
}

$attrs = '';
if ($class_link !== '') {
    $attrs .= ' class="' . htmlspecialchars($class_link) . '"';
}
if ($item->anchor_title) {
    $attrs .= ' title="' . htmlspecialchars($item->anchor_title) . '"';
}
switch ($item->browserNav) {
    case 1:
        $attrs .= ' target="_blank"';
        $rel = 'noopener noreferrer';
        if ($item->anchor_rel === 'nofollow') {
            $rel .= ' nofollow';
        }
        break;
    case 2:
        $attrs .= ' onclick="window.open(this.href,\'targetWindow\',\'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,' .
            $item->params->get('window_open') . '\');return false;"';
        break;
}
if ($rel) {
    $attrs .= ' rel="' . htmlspecialchars($rel) . '"';
}
if ($item->menu_image) {
    $linktype = $item->params->get('menu_text', 1) ?
        '<img src="' . $item->menu_image . '" alt="' . $item->title . '" /><span class="image-title">' . $item->title . '</span> ' :
        '<img src="' . $item->menu_image . '" alt="' . $item->title . '" />';
} else {
    $linktype = $item->title;
}
$flink = $item->flink;
$flink = JFilterOutput::ampReplace(htmlspecialchars($flink));
?><a href="<?php echo $flink; ?>"<?php echo $attrs; ?> rel="external"><?php echo $linktype; ?></a>