<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die('Restricted access');

/** @var JDocumentHTML $document */
/** @var array $headerstuff */
/** @var string $buffer */

$tagEnd = (JPluginHelper::isEnabled('system', 'sh404sef')
    || JPluginHelper::isEnabled('system', 'shsef')
    || JPluginHelper::isEnabled('system', 'acesef')
    || JPluginHelper::isEnabled('system', 'byebyegenerator')
) ? "/>\n" : '>';

// Convert the tagids to titles
if (class_exists('JHelperTags', false) && isset($headerstuff['metaTags']['standard']['tags'])) {
    $tagsHelper = new JHelperTags();
    $headerstuff['metaTags']['standard']['tags'] = implode(', ', $tagsHelper->getTagNames($headerstuff['metaTags']['standard']['tags']));
}

// Generate base tag (need to happen early)
$base = $document->getBase();
if (!empty($base)) {
    $buffer .= '<base href="' . $base . '"' . $tagEnd;
}

// Generate META tags (needs to happen as early as possible in the head)
foreach ($headerstuff['metaTags'] as $type => $tag) {
    foreach ($tag as $name => $content) {
        if ($type === 'http-equiv' && !($document->isHtml5() && $name === 'content-type')) {
            $buffer .= '<meta http-equiv="' . $name . '" content="' . htmlspecialchars($content) . '"' . $tagEnd;
        } elseif ($type === 'standard' && !empty($content)) {
            $buffer .= '<meta name="' . $name . '" content="' . htmlspecialchars($content) . '"' . $tagEnd;
        }
    }
}

// Don't add empty descriptions
$documentDescription = $document->getDescription();
if ($documentDescription) {
    $buffer .= '<meta name="description" content="' . htmlspecialchars($documentDescription) . '"' . $tagEnd;
}

// Don't add empty generators
$generator = $document->getGenerator();
if ($generator) {
    $buffer .= '<meta name="generator" content="' . htmlspecialchars($generator) . '"' . $tagEnd;
}

$buffer .= '<title>' . htmlspecialchars($document->getTitle(), ENT_COMPAT, 'UTF-8') . '</title>';

// Generate link declarations
foreach ($headerstuff['links'] as $link => $linkAtrr) if ($link) {
    $buffer .= '<link href="' . $link . '" ' . $linkAtrr['relType'] . '="' . $linkAtrr['relation'] . '"';
    if ($temp = JArrayHelper::toString($linkAtrr['attribs'])) {
        $buffer .= ' ' . $temp;
    }
    $buffer .= $tagEnd;
}

// Generate icons
$buffer .= $this->loadIcons();

// Generate preloaded link declarations
foreach ($headerstuff['preload_styleSheets'] as $strSrc => $strAttr) if ($strSrc) {
    $buffer .= '<link rel="stylesheet" href="' . $strSrc . '"' . $tagEnd;
    $this->loaded_css[$strSrc] = 1;
}

// Generate Template link declaration
$buffer .= $this->loadCSS();

// Generate stylesheet links
foreach ($headerstuff['styleSheets'] as $strSrc => $strAttr) if ($strSrc && !$this->isExcludedCss($strSrc)) {
    $conditional = isset($strAttr['options']['conditional']) ? $strAttr['options']['conditional'] : null;
    if ($conditional !== null) {
        $buffer .= '<!--[if ' . $conditional . ']>';
    }
    $buffer .= '<link rel="stylesheet" href="' . $strSrc . '"';
    $type = isset($strAttr['type']) ? $strAttr['type'] : @$strAttr['mime'];
    if ($type !== 'text/css') {
        $buffer .= ' type="' . $type . '"';
    }
    if (isset($strAttr['media'])) {
        $buffer .= ' media="' . $strAttr['media'] . '" ';
    }
    $attribs = isset($strAttr['attribs']) ? $strAttr['attribs'] : $strAttr;
    unset($attribs['type'], $attribs['mime'], $attribs['options'], $attribs['media']);
    if ($temp = JArrayHelper::toString($attribs)) {
        $buffer .= ' ' . $temp;
    }
    $buffer .= $tagEnd;
    if ($conditional !== null) {
        $buffer .= '<![endif]-->';
    }
}

// Generate stylesheet declarations
foreach ($headerstuff['style'] as $type => $content) if ($content) {
    $buffer .= '<style';
    if ($type !== 'text/css') {
        $buffer .= " type=\"$type\"";
    }
    $buffer .= ">$content</style>";
}

// Generate preloaded script file links
foreach ($headerstuff['preload_scripts'] as $strSrc => $strAttr) if ($strSrc) {
    $buffer .= '<script src="' . $strSrc . '"></script>';
    $this->loaded_js[$strSrc] = 1;
}

// Generate Template script file links (with custom.js)
$buffer .= $this->loadJS();

// Generate script file links
foreach ($headerstuff['scripts'] as $strSrc => $strAttr) if ($strSrc && !$this->isExcludedJs($strSrc)) {
    $conditional = isset($attribs['options']['conditional']) ? $attribs['options']['conditional'] : null;
    if ($conditional !== null) {
        $buffer .= '<!--[if ' . $conditional . ']>';
    }
    $buffer .= '<script src="' . $strSrc . '"';
    $type = isset($strAttr['type']) ? $strAttr['type'] : @$strAttr['mime'];
    if ($type !== null && $type !== 'text/javascript') {
        $buffer .= ' type="' . $type . '"';
    }
    if (!empty($strAttr['defer'])) {
        $buffer .= ' defer="defer"';
    }
    if (!empty($strAttr['async'])) {
        $buffer .= ' async="async"';
    }
    $attribs = $strAttr;
    unset($attribs['type'], $attribs['mime'], $attribs['options'], $attribs['defer'], $attribs['async']);
    if ($temp = JArrayHelper::toString($attribs)) {
        $buffer .= ' ' . $temp;
    }
    $buffer .= '></script>';
    if ($conditional !== null) {
        $buffer .= '<![endif]-->';
    }
}

// Generate script declarations
foreach ($headerstuff['script'] as $type => $content) if ($content) {
    $buffer .= '<script';
    if ($type !== 'text/javascript') {
        $buffer .= " type=\"$type\"";
    }
    $buffer .= ">\n$content\n</script>";
}

// Generate script language declarations.
if (count(JText::script())) {
    $buffer .= '<script type="text/javascript">' . "\n";
    $buffer .= '(function(){';
    $buffer .= 'var strings=' . json_encode(JText::script()) . ';';
    $buffer .= 'if(typeof Joomla==\'undefined\'){';
    $buffer .= 'Joomla={};';
    $buffer .= 'Joomla.JText=strings;';
    $buffer .= '}else{';
    $buffer .= 'Joomla.JText.load(strings);';
    $buffer .= '}';
    $buffer .= '})();';
    $buffer .= '</script>';
}

foreach ($headerstuff['custom'] as $custom) if ($custom) {
    $buffer .= $custom . "\n";
}

if (@filesize(JPATH_THEMES . '/' . $this->template . '/css/custom.css')) {
    $buffer .= $this->htmlCSS($this->base . 'css/custom.css');
}
