<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die('Restricted access');

jQMHelper::process($this->params);

class jQMHelper
{
    public static $params;

    public static function process($params)
    {
        self::$params = $params;

        self::parseComponentBuffer();

        JFactory::getApplication()->registerEvent('onAfterRender', 'jQMHelper_onAfterRender');
    }

    private static function parseComponentBuffer()
    {
        /** @var JDocumentHtml $document */
        $document = JFactory::getDocument();
        $content = $document->getBuffer('component');

        // pagination plugin
        if (class_exists('plgContentPagenavigation', false)) {
            $content = preg_replace_callback('#<ul class="pagenav">(.*?)</ul>#s', array('jQMHelper', 'pagenav_replacer'), $content);
        }

        // pagebreak plugin
        if (class_exists('plgContentPagebreak', false)) {
            $content = preg_replace_callback('#<div class="pull-right article-index">\s*(?:<h3>(.*?)</h3>)?\s*<ul class="nav nav-tabs nav-stacked">(.*?)</ul>\s*</div>#s', array('jQMHelper', 'pagebreak_toc_replacer'), $content);
            $content = preg_replace_callback('#<div class="pager"><ul><li>(.*?)</li><li>(.*?)</li></ul></div>#s', array('jQMHelper', 'pagebreak_nav_replacer'), $content);
        }

        $document->setBuffer($content, 'component');
    }

    public static function pagenav_replacer($matches)
    {
        $theme = JFactory::getDocument()->params->get('theme_pagination');
        if ($theme) {
            $theme = ' data-theme="' . $theme . '"';
        }
        $inner = $matches[1];
        $inner = preg_replace('#<li class="pagenav-prev">\s*<a href="(.*?)" rel="(?:prev|next)">(.*?)</a>\s*</li>#s', '<a data-role="button" data-inline="true" href="\1" data-direction="reverse">\2</a>', $inner);
        $inner = preg_replace('#<li class="pagenav-next">\s*<a href="(.*?)" rel="(?:prev|next)">(.*?)</a>\s*</li>#s', '<a data-role="button" data-inline="true" href="\1">\2</a>', $inner);
        return '<div data-role="controlgroup" data-type="horizontal"' . $theme . ' class="pagenav">' . $inner . '</div>';
    }

    public static function pagebreak_toc_replacer($matches)
    {
        $tocTitle = $matches[1];
        if (empty($tocTitle)) {
            $tag = JFactory::getLanguage()->getTag();
            $filename = JPATH_ADMINISTRATOR . "/language/$tag/$tag.plg_content_pagebreak.ini";
            if (file_exists($filename)) {
                $contents = file_get_contents($filename);
                $contents = str_replace('_QQ_', '"\""', $contents);
                $strings = @parse_ini_string($contents);
                $tocTitle = @$strings['PLG_CONTENT_PAGEBREAK_TOC_LABEL'];
            }
        }
        return
            '<div data-role="collapsible" class="article-index">'
            . '<h3>' . $tocTitle . '</h3>'
            . '<ol data-role="listview" data-inset="true">'
            . $matches[2]
            . '</ol></div>';
    }

    public static function pagebreak_nav_replacer($matches)
    {
        $theme = JFactory::getDocument()->params->get('theme_pagination');
        if ($theme) {
            $theme = ' data-theme="' . $theme . '"';
        }
        $prev = $matches[1];
        $next = $matches[2];
        if (strncmp($prev, '<a ', 3) === 0) {
            $prev = '<a data-role="button" data-inline="true"' . substr($prev, 2);
        } else {
            $prev = '<span data-role="button" data-inline="true" class="ui-btn ui-disabled">' . $prev . '</span>';
        }
        if (strncmp($next, '<a ', 3) === 0) {
            $next = '<a data-role="button" data-inline="true"' . substr($next, 2);
        } else {
            $next = '<span data-role="button" data-inline="true" class="ui-btn ui-disabled">' . $next . '</span>';
        }
        return
            '<div data-role="controlgroup" data-type="horizontal"' . $theme . ' class="pagination pagenav">'
            . $prev . $next
            . '</div>';
    }
}

function jQMHelper_onAfterRender()
{
    $buffer = JResponse::getBody();

    if ($buffer) {
        JResponse::setBody($buffer);
    }

    return true;
}
