<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version     2.1.47
 * @license     GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright   (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date        May 2020
 */
header('Content-Type: text/css');

$once_flag = dirname(__FILE__) . '/once.flag';
if (!is_file($once_flag)) {
    return;
}

define('_JEXEC', 1);
define('DS', DIRECTORY_SEPARATOR);
define('JPATH_BASE', dirname(dirname(dirname(dirname(__FILE__)))) . DS . 'administrator');
require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';

jimport('joomla.filesystem.file');

$once_flag = dirname(__FILE__) . '/once.flag';
JFile::delete($once_flag);
clearstatcache();
if (is_file($once_flag)) {
    return;
}

$template_path = dirname(dirname(__FILE__)) . '/';

$names = array(
    'css/custom.css',
    'css/custom_preload.txt',
    'js/custom.js',
    'js/custom_preload.txt',
);
$data = '';
foreach ($names as $name) {
    if (!is_file($template_path . $name)) {
        JFile::write($template_path . $name, $data);
    }
}

$names = array(
    '.htaccess' => array('56868306b03ba249b6bc4dc4d2912940', '57372b279ee1ccdafb16837339f9036b'),
    'favicon.ico' => array('4682009df58c0fe58ee462247355de56'),
    'logo.png' => array('c74492c3b4d777f4bd30157d95a757b8', '562d4fefcd3be5fc2b7d92a9004aa07b'),
    'touch-icon-precomposed-144x144.png' => array(),
    'touch-icon-precomposed-114x114.png' => array(),
    'touch-icon-precomposed-72x72.png' => array(),
    'touch-icon-precomposed-57x57.png' => array(),
    'touch-icon-144x144.png' => array('5c17e73ae570a57a7a67c19011c38197', 'cbc4b37e02f8b1e818ec99e6931b3d32'),
    'touch-icon-114x114.png' => array('de886d9bab2b8e1b54e4c743a52c1d77', '69866b2df2ad0be628d19246b0ef43c8'),
    'touch-icon-72x72.png' => array('bf4a63caf52b0a96fb651f29372b39b8', '18d0d74a316b4c5f281ade15548d2ed7'),
    'touch-icon-57x57.png' => array('dd17a227d9a091e35061b69c63f1a45a', '471552779001426276e474c8eee482dd'),
    'touch-startup-image-320x460.png' => array('8e2ace1b05e138a16713bfb93ef79701', '44d8fe4371876f31261adc658196f6b5'),
    'touch-startup-image-640x920.png' => array(),
    'touch-startup-image-640x1096.png' => array(),
    'touch-startup-image-768x1004.png' => array(),
    'touch-startup-image-1024x748.png' => array(),
    'touch-startup-image-1536x2008.png' => array(),
    'touch-startup-image-2048x1496.png' => array(),
);

$installed_flag = dirname(__FILE__) . '/installed.flag';
if (is_file($installed_flag)) {
    if (!is_file($template_path . '.htaccess')) {
        unset($names['.htaccess']);
    }
} else {
    JFile::write($installed_flag, $data);
}

$do_copy = true;

foreach ($names as $name => $hashes) {
    if (is_file($template_path . $name) &&
        !in_array(md5_file($template_path . $name), $hashes, true)
    ) {
        $do_copy = false;
        break;
    }
}

if (!$do_copy) {
    return;
}

foreach ($names as $name => $hashes) {
    if (is_file($template_path . 'media/' . $name)) {
        if (is_file($template_path . $name)) {
            JFile::delete($template_path . $name);
        }
        JFile::copy($template_path . 'media/' . $name, $template_path . $name);
    }
}
